% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClassesCE.R
\docType{class}
\name{ClusterExperiment-class}
\alias{ClusterExperiment-class}
\alias{ClusterExperiment}
\alias{ClusterExperiment,matrixOrHDF5,ANY-method}
\alias{ClusterExperiment,SummarizedExperiment,ANY-method}
\alias{ClusterExperiment,SingleCellExperiment,numeric-method}
\alias{ClusterExperiment,SingleCellExperiment,character-method}
\alias{ClusterExperiment,SingleCellExperiment,factor-method}
\alias{ClusterExperiment,SingleCellExperiment,matrix-method}
\title{Class ClusterExperiment}
\usage{
ClusterExperiment(object, clusters, ...)

\S4method{ClusterExperiment}{matrixOrHDF5,ANY}(object, clusters, ...)

\S4method{ClusterExperiment}{SummarizedExperiment,ANY}(object, clusters, ...)

\S4method{ClusterExperiment}{SingleCellExperiment,numeric}(object, clusters, ...)

\S4method{ClusterExperiment}{SingleCellExperiment,character}(object, clusters, ...)

\S4method{ClusterExperiment}{SingleCellExperiment,factor}(object, clusters, ...)

\S4method{ClusterExperiment}{SingleCellExperiment,matrix}(
  object,
  clusters,
  transformation = function(x) {
     x
 },
  primaryIndex = 1,
  clusterTypes = "User",
  clusterInfo = NULL,
  orderSamples = seq_len(ncol(object)),
  dendro_samples = NULL,
  dendro_index = NA_real_,
  dendro_clusters = NULL,
  coClustering = NULL,
  merge_index = NA_real_,
  merge_cutoff = NA_real_,
  merge_dendrocluster_index = NA_real_,
  merge_nodeProp = NULL,
  merge_nodeMerge = NULL,
  merge_method = NA_character_,
  merge_demethod = NA_character_,
  clusterLegend = NULL,
  checkTransformAndAssay = TRUE
)
}
\arguments{
\item{object}{a matrix or \code{SummarizedExperiment} or
\code{SingleCellExperiment} containing the data that was clustered.}

\item{clusters}{can be either a numeric or character vector, a factor, or a
numeric matrix, containing the cluster labels.}

\item{...}{The arguments \code{transformation}, \code{clusterTypes} and
\code{clusterInfo} to be passed to the constructor for signature
\code{SingleCellExperiment,matrix}.}

\item{transformation}{function. A function to transform the data before
performing steps that assume normal-like data (i.e. constant variance), such
as the log.}

\item{primaryIndex}{integer. Sets the `primaryIndex` slot (see Slots).}

\item{clusterTypes}{a string describing the nature of the clustering. The
values `clusterSingle`, `clusterMany`, `mergeClusters`, `makeConsensus` are
reserved for the clustering coming from the package workflow and should not
be used when creating a new object with the constructor.}

\item{clusterInfo}{a list with information on the clustering (see Slots).}

\item{orderSamples}{a vector of integers. Sets the `orderSamples` slot (see
Slots).}

\item{dendro_samples}{phylo4 object. Sets the `dendro_samples` slot (see Slots).}

\item{dendro_index}{numeric. Sets the \code{dendro_index} slot (see Slots).}

\item{dendro_clusters}{phylo4 object. Sets the `dendro_clusters` slot (see
Slots).}

\item{coClustering}{matrix. Sets the \code{coClustering} slot (see Slots).}

\item{merge_index}{integer. Sets the \code{merge_index} slot (see Slots)}

\item{merge_cutoff}{numeric. Sets the \code{merge_cutoff} slot (see Slots)}

\item{merge_dendrocluster_index}{integer. Sets the
\code{merge_dendrocluster_index} slot (see Slots)}

\item{merge_nodeProp}{data.frame. Sets the \code{merge_nodeProp} slot (see
Slots)}

\item{merge_nodeMerge}{data.frame. Sets the \code{merge_nodeMerge} slot (see
Slots)}

\item{merge_method}{character, Sets the \code{merge_method} slot (see Slots)}

\item{merge_demethod}{character, Sets the
\code{merge_demethod} slot (see Slots)}

\item{clusterLegend}{list, Sets the \code{clusterLegend} slot (see details).}

\item{checkTransformAndAssay}{logical. Whether to check the content of the
assay and given transformation function for whether they are valid.}
}
\value{
A \code{ClusterExperiment} object.
}
\description{
\code{ClusterExperiment} is a class that extends
\code{SingleCellExperiment} and is used to store the data
and clustering information.

In addition to the slots of the \code{SingleCellExperiment}
class, the \code{ClusterExperiment} object has the additional slots described
in the Slots section.

There are several methods implemented for this class. The most
important methods (e.g., \code{\link{clusterMany}}, \code{\link{makeConsensus}},
...) have their own help page. Simple helper methods are described in the
Methods section. For a comprehensive list of methods specific to this class
see the Reference Manual.

The constructor \code{ClusterExperiment} creates an object of the
 class \code{ClusterExperiment}. However, the typical way of creating these
 objects is the result of a call to \code{\link{clusterMany}} or
 \code{\link{clusterSingle}}.

Note that when subsetting the data, the co-clustering and
 dendrogram information are lost.
}
\details{
The \code{clusterLegend} argument to \code{ClusterExperiment} 
 must be a valid clusterLegend format and match the values in \code{clusters}, 
in that the "clusterIds" column must matches the value in the clustering matrix
 \code{clusters}. If \code{names(clusterLegend)==NULL}, it is assumed that the 
 entries of \code{clusterLegend} are in the same order as the columns of 
 \code{clusters}. Generally, this is not a good way for users to set the
clusterLegend slot.

The \code{ClusterExperiment} constructor function gives
  clusterLabels based on the column names of the input
  matrix/SingleCellExperiment. If missing, will assign labels
  "cluster1","cluster2", etc.

Note that the validity check when creating a new
  \code{ClusterExperiment} object with \code{new} is less extensive than when
  using \code{ClusterExperiment} function with
  \code{checkTransformAndAssay=TRUE} (the default). Users are advised to use
  \code{ClusterExperiment} to create new \code{ClusterExperiment} objects.
}
\section{Slots}{

\describe{
\item{\code{transformation}}{function. Function to transform the data by when methods
that assume normal-like data (e.g. log)}

\item{\code{clusterMatrix}}{matrix. A matrix giving the integer-valued cluster ids
for each sample. The rows of the matrix correspond to clusterings and columns
to samples. The integer values are assigned in the order that the clusters
were found, if found by setting sequential=TRUE in clusterSingle. "-1" indicates
the sample was not clustered.}

\item{\code{primaryIndex}}{numeric. An index that specifies the primary set of
labels.}

\item{\code{clusterInfo}}{list. A list with info about the clustering.
If created from \code{\link{clusterSingle}}, clusterInfo will include the
parameter used for the call, and the call itself. If \code{sequential = TRUE}
it will also include the following components.
\itemize{
\item{\code{clusterInfo}}{if sequential=TRUE and clusters were successfully
found, a matrix of information regarding the algorithm behavior for each
cluster (the starting and stopping K for each cluster, and the number of
iterations for each cluster).}
\item{\code{whyStop}}{if sequential=TRUE and clusters were successfully
found, a character string explaining what triggered the algorithm to stop.}
}}

\item{\code{merge_index}}{index of the current merged cluster}

\item{\code{merge_cutoff}}{value for the cutoff used to determine whether to merge
clusters}

\item{\code{merge_dendrocluster_index}}{index of the cluster merged with the current
merge}

\item{\code{merge_nodeMerge}}{data.frame of information about nodes merged in the
current merge. See \code{\link{mergeClusters}}}

\item{\code{merge_nodeProp}}{data.frame of information of proportion estimated
non-null at each node of dendrogram. See \code{\link{mergeClusters}}}

\item{\code{merge_method}}{character indicating method used for merging. See 
\code{\link{mergeClusters}}}

\item{\code{merge_demethod}}{character indicating the DE method used for merging. See 
\code{\link{mergeClusters}}}

\item{\code{clusterTypes}}{character vector with the origin of each column of
clusterMatrix.}

\item{\code{dendro_samples}}{\code{\link[phylobase]{phylo4d}} object. A dendrogram
containing the cluster relationship (leaves are samples; see
\code{\link{clusterDendrogram}} for details).}

\item{\code{dendro_clusters}}{\code{\link[phylobase]{phylo4d}} object. A dendrogram
containing the cluster relationship (leaves are clusters; see see
\code{\link{sampleDendrogram}} for details).}

\item{\code{dendro_index}}{numeric. An integer giving the cluster that was used to
make the dendrograms. NA_real_ value if no dendrograms are saved.}

\item{\code{coClustering}}{One of \itemize{ 
\item{\code{NULL}, i.e. empty} 
\item{a
  numeric vector, signifying the indices of the clusterings in the
  clusterMatrix that were used for \code{makeConsensus}. This allows for the
  recreation of the distance matrix (using hamming distance) if needed for
  function \code{plotClusters} but doesn't require storage of full NxN
  matrix.} 
\item{a \code{\link[Matrix]{sparseMatrix}} object -- a sparse 
  representation of the NxN matrix with the cluster co-occurrence 
  information; this can either be based on subsampling or on co-clustering 
  across parameter sets (see \code{clusterMany}). The matrix is a square
  matrix with number of rows/columns equal to the number of samples.}
}}

\item{\code{clusterLegend}}{a list, one per cluster in \code{clusterMatrix}. Each
element of the list is a matrix with nrows equal to the number of different
clusters in the clustering, and consisting of at least two columns with the
following column names: "clusterId" and "color".}

\item{\code{orderSamples}}{a numeric vector (of integers) defining the order of
samples to be used for plotting of samples. Usually set internally by other
functions.}
}}

\examples{

sce <- matrix(data=rnorm(200), ncol=10)
labels <- gl(5, 2)

cc <- ClusterExperiment(sce, as.numeric(labels), transformation =
function(x){x})

}
\seealso{
\code{\link[Matrix]{sparseMatrix}} \code{\link[phylobase]{phylo4d}}
}
