% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allClasses.R
\name{createanClique}
\alias{createanClique}
\alias{createanClique,xcmsSet-method}
\alias{createanClique,XCMSnExp-method}
\title{'createanClique' generic function to create an object
of class 'anClique'.}
\usage{
createanClique(mzdata)

\S4method{createanClique}{xcmsSet}(mzdata)

\S4method{createanClique}{XCMSnExp}(mzdata)
}
\arguments{
\item{mzdata}{An object with processed m/z data. See methods for
valid class types.}
}
\value{
An 'anClique' S4 object with all elements to perform clique grouping,
isotope annotation and adduct annotation.
}
\description{
\code{createanClique} creates an 'anClique' object from processed m/z data.e
}
\section{Functions}{
\itemize{
\item \code{createanClique(xcmsSet)}: Method for 'xcmsSet' object

\item \code{createanClique(XCMSnExp)}: Method for 'XCMSnExp' object

}}
\examples{
## Using a 'XCMSnExp' object
mzfile <- system.file("standards.mzXML", package = "cliqueMS")
library(xcms)
mzraw <- MSnbase::readMSData(files = mzfile, mode = "onDisk")
cpw <- CentWaveParam(ppm = 15, peakwidth = c(5,20), snthresh = 10)
mzData <- findChromPeaks(object = mzraw, param = cpw)
ex.anClique <- createanClique(mzdata = mzData)
show(ex.anClique)

## Using a 'xcmsSet' object
mzfile <- system.file("standards.mzXML", package = "cliqueMS")
msSet <- xcms::xcmsSet(files = mzfile, method = "centWave",
ppm = 15, peakwidth = c(5,20), snthresh = 10)
ex.anClique <- createanClique(msSet)
}
\seealso{
\code{\link{anClique}}
}
