% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fusion_transcript.R
\name{plot_fusion_transcript}
\alias{plot_fusion_transcript}
\title{Plot possible fusion transcripts based on annotation.}
\usage{
plot_fusion_transcript(
  fusion,
  edb = NULL,
  bamfile = NULL,
  which_transcripts = "exonBoundary",
  bedgraphfile = NULL
)
}
\arguments{
\item{fusion}{The Fusion object to plot.}

\item{edb}{The edb object that will be used to fetch data.}

\item{bamfile}{The bamfile with RNA-seq data.}

\item{which_transcripts}{This character vector decides which transcripts are
to be plotted. Can be "exonBoundary", "withinExon", "withinIntron",
"intergenic", or a character vector with specific transcript ids. Default
value is "exonBoundary".}

\item{bedgraphfile}{A bedGraph file to use instead of the bamfile to plot
coverage.}
}
\value{
Creates a fusion transcript plot.
}
\description{
This function takes a fusion object and an ensembldb object and plots the
reduced version of the fusion transcript. This transcript consist of the
"mashed together" version of all possible fusion transcripts based on known
annotations. If a bamfile is specified, the fusion transcript will be
plotted with coverage information.
}
\details{
Note that the transcript database used (the edb object) must have the same
seqnames as any bamfile used. Otherwise the coverage data will be wrong.
}
\examples{
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# bamfile with reads in the regions of this fusion event
bamfile5267 <- system.file(
  "extdata",
  "fusion5267and11759reads.bam",
  package="chimeraviz")
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 500, height = 500)
# Plot!
plot_fusion_transcript(
  fusion = fusion,
  bamfile = bamfile5267,
  edb = edb)
# Close device
dev.off()

# Example using a .bedGraph file instead of a .bam file:
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# bedgraphfile with coverage data from the regions of this fusion event
bedgraphfile <- system.file(
  "extdata",
  "fusion5267and11759reads.bedGraph",
  package="chimeraviz")
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Open device
png(pngFilename, width = 500, height = 500)
# Plot!
plot_fusion_transcript(
  fusion = fusion,
  bamfile = bamfile5267,
  edb = edb)
# Close device
dev.off()

}
