% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_jaffa.R
\name{import_jaffa}
\alias{import_jaffa}
\title{Import results from a JAFFA run into a list of Fusion objects.}
\usage{
import_jaffa(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the jaffa_results.csv file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a JAFFA run, typically from a
jaffa_results.csv file, into a list of Fusion objects.
}
\examples{
jaffaData <- system.file(
  "extdata",
  "jaffa_results.csv",
  package = "chimeraviz")
fusions <- import_jaffa(jaffaData, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
