% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fusion_by.R
\name{get_fusion_by_id}
\alias{get_fusion_by_id}
\title{Find a specific fusion object in a list by id}
\usage{
get_fusion_by_id(fusion_list, id)
}
\arguments{
\item{fusion_list}{A list of Fusion objects.}

\item{id}{The id (e.g. the cluster_id from a deFuse run) we're looking for.}
}
\value{
A Fusion object.
}
\description{
Helper function to retrieve the Fusion object with the given id.
}
\examples{
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# This should be the Fusion object:
fusion
# [1] "Fusion object"
# [1] "id: 5267"
# [1] "Fusion tool: defuse"
# [1] "Genome version: hg19"
# [1] "Gene names: RCC1-HENMT1"
# [1] "Chromosomes: chr1-chr1"
# [1] "Strands: +,-"

}
