% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDF5ArraySeed.R
\name{saveDelayedObject,HDF5ArraySeed-method}
\alias{saveDelayedObject,HDF5ArraySeed-method}
\alias{saveDelayedObject,H5SparseMatrixSeed-method}
\title{Save HDF5-based seeds}
\usage{
\S4method{saveDelayedObject}{HDF5ArraySeed}(x, file, name)

\S4method{saveDelayedObject}{H5SparseMatrixSeed}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{HDF5ArraySeed} or \linkS4class{H5SparseMatrix} object or subclass thereof.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the HDF5-based seed.
}
\description{
Save \linkS4class{HDF5ArraySeed} or \linkS4class{H5SparseMatrix} objects or their subclasses.
See \dQuote{External HDF5 arrays} at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
library(HDF5Array)
X <- writeHDF5Array(matrix(runif(100), ncol=20))
Y <- X + 1
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
