% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedAperm.R
\name{saveDelayedObject,DelayedAperm-method}
\alias{saveDelayedObject,DelayedAperm-method}
\title{Saving a DelayedAperm}
\usage{
\S4method{saveDelayedObject}{DelayedAperm}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedAperm} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedAperm.
}
\description{
Save a \linkS4class{DelayedAperm} object.
See the \dQuote{Transposition} operation at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=20))
Y <- t(X)
temp <- tempfile(fileext=".h5")
saveDelayed(Y, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
