% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cnv_solution.R
\name{plot_cnv_solution}
\alias{plot_cnv_solution}
\title{Plot Fragment-length profile with CNV calling result}
\usage{
plot_cnv_solution(
  cnvcall,
  selected_solution = 1,
  genome = "hg19",
  ylim = c(-30, 30)
)
}
\arguments{
\item{cnvcall}{solution results from call_cnv function}

\item{selected_solution}{solution rank to plot}

\item{genome}{Character; version of reference genome (default hg19)}

\item{ylim}{Vector of 2 Int; ylim of plot (default c(-20,20))}
}
\value{
ggplot object plot Genomics CNV profile of selected solution
}
\description{
Plot Fragment-length profile with CNV calling result
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)
sample_zscore_segment <- segmentByPSCB(sample_zscore)

sample_cnv <- call_cnv(sample_zscore_segment,sample_zscore, tfs=c(0.1,0.3),ploidies=c(1.5,2), MaxCN=3)
plot_cnv_solution(sample_cnv,selected_solution = 1)

}
