% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fragment_profile.R
\name{extract_insert_size}
\alias{extract_insert_size}
\title{Extract Insert size from SampleBam}
\usage{
extract_insert_size(readbam_bin, maximum_length = 600, minimum_length = 20)
}
\arguments{
\item{readbam_bin}{SampleBam Object}

\item{maximum_length}{Int; Maximum length of fragment. cfDNA fragment longer than this value will not be considered; Default 600}

\item{minimum_length}{Int; Minimum length of fragment. cfDNA fragment shorter than this value will not be considered;  Default 20}
}
\value{
Numeric Vector; Insert size of given sample
}
\description{
Extract Insert size from SampleBam
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
extract_insert_size(sample_bambin)
### Extract only insert size of fragment having specific size
extract_insert_size(sample_bambin,maximum_length=500, minimum_length = 50)
}
