% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFractionPie.R
\name{PlotFractionPie}
\alias{PlotFractionPie}
\title{Plot Pie Chart}
\usage{
PlotFractionPie(
  fraction_vector,
  title = "Composition",
  threshold = 0.01,
  class_colors = NULL,
  font_size = 1
)
}
\arguments{
\item{fraction_vector}{a named numeric vector or one-row data.frame, 
where each value represents a class proportion.}

\item{title}{the title of the plot.}

\item{threshold}{a numeric value. Classes with fraction values below this 
threshold will be grouped into "Other".}

\item{class_colors}{a named character vector assigning colors to specific 
class names (e.g., c("tumor" = "red")).}

\item{font_size}{numeric, font scaling factor (default is 1.0).}
}
\value{
A pie chart is plotted to the current device.
}
\description{
Generate a pie chart for a vector of class fractions (e.g., tissue 
composition or cfDNA fractions). Automatically filters small values 
into an "Other" group, and allows for custom colors and font size control.
}
\examples{
df <- data.frame(
  WBC = 0.93,
  Liver = 0.04,
  Lung = 0.02,
  Muscle = 1.2345e-4,
  Stomach = 9.87655e-03
)
PlotFractionPie(df, title = "cfDNA Composition", font_size = 1.2)

}
