% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_singlecluster.R
\name{simulate_singlecluster}
\alias{simulate_singlecluster}
\title{Simulation of data with a censored covariate}
\usage{
simulate_singlecluster(
  n,
  formula,
  type = c("lm", "glm", "glmer"),
  b = NULL,
  n_levels_fixeff = NULL,
  n_levels_raneff = NULL,
  weibull_params = list(X = list(shape = 0.5, scale = 0.25), C = list(shape = 1, scale
    = 0.25)),
  censoring_dependent_on_covariate = FALSE,
  weibull_params_covariate_dependent_censoring = list(shape = 1, scale = 0.1),
  error_variance = 0,
  variance_raneff = 0.5,
  transform_fn = "identity",
  verbose = FALSE
)
}
\arguments{
\item{n}{number of samples}

\item{formula}{the formula to specify the structure in the data. The censored
variable should be written in the following format: 'Surv(X,I)', where 'X' is the observed
value, and 'I' is the event indicator (1 if observed, 0 if censored).
A full example is: 'Y ~ Surv(X,I) + Covariate + (1|Random_effect)'.}

\item{type}{which regression type is used, one of 'lm', 'glm', 'glmer'. For
the generalized linear models the response is binomial with a logistic link
function. default = 'lm'.}

\item{b}{the regression coefficients, either
\describe{
 \item{NUll}{will us 0 for the intercept and 1
 for the remaining coefficients} 
 \item{a vector with regression coefficients}{the length has to be (1 
 (intercept) + number of covariates (including the censored covariate))}
  }}

\item{n_levels_fixeff}{The number of levels to use for each covariate, e.g.
for two covariates: c(10,100). If NULL sets all to 2 (two groups).}

\item{n_levels_raneff}{The number of levels to use for each random effect. 
If NULL sets to 'n' (observation level random effects).}

\item{weibull_params}{The parameters for the distribution of the censored
variable and the censoring time. Should be a list of lists, where the elements
of the outer lists are 'X' the true value and 'C' the censoring time. The
inner lists should have two keywords, 'shape' and 'scale', for the parameters
of the Weibull distribution (See \code{\link[stats]{Weibull}}).}

\item{censoring_dependent_on_covariate}{Logical. If
censoring should depend on a covariate. The respective covariate needs to
have only two levels ('n_level_fixeff'=2). Will use first covariate
in formula.}

\item{weibull_params_covariate_dependent_censoring}{list with two elements,
shape and scale, representing the parameters of a weibull distribution for
the second level of a covariate if 'censoring_dependent_on_covariate'=TRUE.}

\item{error_variance}{positive double. Variance of additional gaussian
noise to add in the linear sum of the predictors. For linear regression
this is the only error added. Otherwise it should be set to zero. default = 0.}

\item{variance_raneff}{positive double vector of the length of 
'n_levels_raneff'. The variance of the gaussian distributed
random effect covariates. default = 0.5.}

\item{transform_fn}{function to transform censored covariate or one of
'identity' (no transformation), 'boxcox' (box-cox transformation),
'boxcox_positive' (box-cox transformation and translation to all positive
 values), 'log_positive' (log transformation and translation to all positive
 values). The transformation is applied before the response is modeled.  
 default = 'identity'.}

\item{verbose}{verbose}
}
\value{
\code{\link[tibble]{tibble}}
}
\description{
Function to simulate an association between a censored covariate and a predictor.
}
\examples{
# single differential cluster
 glmer_formula <- formula(Y ~ Surv(X,I) + Z + (1|R))
 simulate_singlecluster(100, glmer_formula, type = "glmer")
 
}
