// Generated by rstantools.  Do not edit by hand.

/*
    cellvel is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    cellvel is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cellvel.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_gen_F_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 66> locations_array__ =
  {" (found before start of program)",
  " (in 'gen_F', line 27, column 4 to column 20)",
  " (in 'gen_F', line 28, column 4 to column 40)",
  " (in 'gen_F', line 29, column 4 to column 35)",
  " (in 'gen_F', line 30, column 4 to column 32)",
  " (in 'gen_F', line 31, column 4 to column 28)",
  " (in 'gen_F', line 32, column 4 to column 29)",
  " (in 'gen_F', line 33, column 4 to column 30)",
  " (in 'gen_F', line 34, column 4 to column 29)",
  " (in 'gen_F', line 35, column 4 to column 29)",
  " (in 'gen_F', line 36, column 4 to column 18)",
  " (in 'gen_F', line 37, column 4 to column 21)",
  " (in 'gen_F', line 38, column 4 to column 16)",
  " (in 'gen_F', line 41, column 8 to column 67)",
  " (in 'gen_F', line 40, column 24 to line 42, column 5)",
  " (in 'gen_F', line 40, column 4 to line 42, column 5)",
  " (in 'gen_F', line 44, column 8 to column 67)",
  " (in 'gen_F', line 43, column 24 to line 45, column 5)",
  " (in 'gen_F', line 43, column 4 to line 45, column 5)",
  " (in 'gen_F', line 46, column 4 to column 71)",
  " (in 'gen_F', line 47, column 4 to column 73)",
  " (in 'gen_F', line 48, column 4 to column 63)",
  " (in 'gen_F', line 49, column 4 to column 77)",
  " (in 'gen_F', line 51, column 4 to column 16)",
  " (in 'gen_F', line 55, column 12 to column 63)",
  " (in 'gen_F', line 59, column 20 to column 74)",
  " (in 'gen_F', line 58, column 30 to line 60, column 17)",
  " (in 'gen_F', line 58, column 16 to line 60, column 17)",
  " (in 'gen_F', line 62, column 20 to column 91)",
  " (in 'gen_F', line 61, column 30 to line 63, column 17)",
  " (in 'gen_F', line 61, column 16 to line 63, column 17)",
  " (in 'gen_F', line 64, column 16 to column 72)",
  " (in 'gen_F', line 65, column 16 to column 38)",
  " (in 'gen_F', line 57, column 36 to line 66, column 13)",
  " (in 'gen_F', line 57, column 12 to line 66, column 13)",
  " (in 'gen_F', line 53, column 28 to line 67, column 9)",
  " (in 'gen_F', line 53, column 8 to line 67, column 9)",
  " (in 'gen_F', line 68, column 8 to column 27)",
  " (in 'gen_F', line 52, column 24 to line 69, column 5)",
  " (in 'gen_F', line 52, column 4 to line 69, column 5)",
  " (in 'gen_F', line 71, column 4 to column 38)",
  " (in 'gen_F', line 2, column 4 to column 25)",
  " (in 'gen_F', line 3, column 4 to column 25)",
  " (in 'gen_F', line 4, column 4 to column 29)",
  " (in 'gen_F', line 5, column 4 to column 15)",
  " (in 'gen_F', line 7, column 4 to column 25)",
  " (in 'gen_F', line 8, column 4 to column 26)",
  " (in 'gen_F', line 9, column 4 to column 27)",
  " (in 'gen_F', line 10, column 4 to column 28)",
  " (in 'gen_F', line 11, column 4 to column 28)",
  " (in 'gen_F', line 12, column 4 to column 29)",
  " (in 'gen_F', line 13, column 4 to column 26)",
  " (in 'gen_F', line 14, column 4 to column 27)",
  " (in 'gen_F', line 15, column 4 to column 29)",
  " (in 'gen_F', line 16, column 4 to column 30)",
  " (in 'gen_F', line 17, column 4 to column 25)",
  " (in 'gen_F', line 18, column 4 to column 26)",
  " (in 'gen_F', line 21, column 4 to column 58)",
  " (in 'gen_F', line 27, column 12 to column 18)",
  " (in 'gen_F', line 28, column 31 to column 38)",
  " (in 'gen_F', line 28, column 12 to column 19)",
  " (in 'gen_F', line 29, column 21 to column 27)",
  " (in 'gen_F', line 30, column 21 to column 27)",
  " (in 'gen_F', line 31, column 12 to column 18)",
  " (in 'gen_F', line 34, column 12 to column 19)",
  " (in 'gen_F', line 35, column 12 to column 19)"};
#include <stan_meta_header.hpp>
class model_gen_F final : public model_base_crtp<model_gen_F> {
private:
  int N_plate;
  int N_group;
  int N_well_reps;
  int offset;
  double prior_alpha_p_M;
  double prior_alpha_p_SD;
  double prior_sigma_bio_M;
  double prior_sigma_bio_SD;
  double prior_sigma_tech_M;
  double prior_sigma_tech_SD;
  double prior_kappa_mu_M;
  double prior_kappa_mu_SD;
  double prior_kappa_sigma_M;
  double prior_kappa_sigma_SD;
  double prior_delta_t_M;
  double prior_delta_t_SD;
  int N_well;
public:
  ~model_gen_F() {}
  model_gen_F(stan::io::var_context& context__, unsigned int
              random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_gen_F_namespace::model_gen_F";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 41;
      context__.validate_dims("data initialization", "N_plate", "int",
        std::vector<size_t>{});
      N_plate = std::numeric_limits<int>::min();
      current_statement__ = 41;
      N_plate = context__.vals_i("N_plate")[(1 - 1)];
      current_statement__ = 41;
      stan::math::check_greater_or_equal(function__, "N_plate", N_plate, 0);
      current_statement__ = 42;
      context__.validate_dims("data initialization", "N_group", "int",
        std::vector<size_t>{});
      N_group = std::numeric_limits<int>::min();
      current_statement__ = 42;
      N_group = context__.vals_i("N_group")[(1 - 1)];
      current_statement__ = 42;
      stan::math::check_greater_or_equal(function__, "N_group", N_group, 0);
      current_statement__ = 43;
      context__.validate_dims("data initialization", "N_well_reps", "int",
        std::vector<size_t>{});
      N_well_reps = std::numeric_limits<int>::min();
      current_statement__ = 43;
      N_well_reps = context__.vals_i("N_well_reps")[(1 - 1)];
      current_statement__ = 43;
      stan::math::check_greater_or_equal(function__, "N_well_reps",
        N_well_reps, 0);
      current_statement__ = 44;
      context__.validate_dims("data initialization", "offset", "int",
        std::vector<size_t>{});
      offset = std::numeric_limits<int>::min();
      current_statement__ = 44;
      offset = context__.vals_i("offset")[(1 - 1)];
      current_statement__ = 45;
      context__.validate_dims("data initialization", "prior_alpha_p_M",
        "double", std::vector<size_t>{});
      prior_alpha_p_M = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 45;
      prior_alpha_p_M = context__.vals_r("prior_alpha_p_M")[(1 - 1)];
      current_statement__ = 46;
      context__.validate_dims("data initialization", "prior_alpha_p_SD",
        "double", std::vector<size_t>{});
      prior_alpha_p_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 46;
      prior_alpha_p_SD = context__.vals_r("prior_alpha_p_SD")[(1 - 1)];
      current_statement__ = 47;
      context__.validate_dims("data initialization", "prior_sigma_bio_M",
        "double", std::vector<size_t>{});
      prior_sigma_bio_M = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 47;
      prior_sigma_bio_M = context__.vals_r("prior_sigma_bio_M")[(1 - 1)];
      current_statement__ = 48;
      context__.validate_dims("data initialization", "prior_sigma_bio_SD",
        "double", std::vector<size_t>{});
      prior_sigma_bio_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 48;
      prior_sigma_bio_SD = context__.vals_r("prior_sigma_bio_SD")[(1 - 1)];
      current_statement__ = 49;
      context__.validate_dims("data initialization", "prior_sigma_tech_M",
        "double", std::vector<size_t>{});
      prior_sigma_tech_M = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 49;
      prior_sigma_tech_M = context__.vals_r("prior_sigma_tech_M")[(1 - 1)];
      current_statement__ = 50;
      context__.validate_dims("data initialization", "prior_sigma_tech_SD",
        "double", std::vector<size_t>{});
      prior_sigma_tech_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 50;
      prior_sigma_tech_SD = context__.vals_r("prior_sigma_tech_SD")[(1 - 1)];
      current_statement__ = 51;
      context__.validate_dims("data initialization", "prior_kappa_mu_M",
        "double", std::vector<size_t>{});
      prior_kappa_mu_M = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 51;
      prior_kappa_mu_M = context__.vals_r("prior_kappa_mu_M")[(1 - 1)];
      current_statement__ = 52;
      context__.validate_dims("data initialization", "prior_kappa_mu_SD",
        "double", std::vector<size_t>{});
      prior_kappa_mu_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 52;
      prior_kappa_mu_SD = context__.vals_r("prior_kappa_mu_SD")[(1 - 1)];
      current_statement__ = 53;
      context__.validate_dims("data initialization", "prior_kappa_sigma_M",
        "double", std::vector<size_t>{});
      prior_kappa_sigma_M = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 53;
      prior_kappa_sigma_M = context__.vals_r("prior_kappa_sigma_M")[(1 - 1)];
      current_statement__ = 54;
      context__.validate_dims("data initialization", "prior_kappa_sigma_SD",
        "double", std::vector<size_t>{});
      prior_kappa_sigma_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 54;
      prior_kappa_sigma_SD = context__.vals_r("prior_kappa_sigma_SD")[(1 -
        1)];
      current_statement__ = 55;
      context__.validate_dims("data initialization", "prior_delta_t_M",
        "double", std::vector<size_t>{});
      prior_delta_t_M = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 55;
      prior_delta_t_M = context__.vals_r("prior_delta_t_M")[(1 - 1)];
      current_statement__ = 56;
      context__.validate_dims("data initialization", "prior_delta_t_SD",
        "double", std::vector<size_t>{});
      prior_delta_t_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 56;
      prior_delta_t_SD = context__.vals_r("prior_delta_t_SD")[(1 - 1)];
      current_statement__ = 57;
      N_well = std::numeric_limits<int>::min();
      current_statement__ = 57;
      N_well = ((N_plate * N_group) * N_well_reps);
      current_statement__ = 57;
      stan::math::check_greater_or_equal(function__, "N_well", N_well, 0);
      current_statement__ = 58;
      stan::math::validate_non_negative_index("y", "N_well", N_well);
      current_statement__ = 59;
      stan::math::validate_non_negative_index("delta_tp", "N_group", N_group);
      current_statement__ = 60;
      stan::math::validate_non_negative_index("delta_tp", "N_plate", N_plate);
      current_statement__ = 61;
      stan::math::validate_non_negative_index("kappa", "N_well", N_well);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("mu", "N_well", N_well);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("mu_well", "N_well", N_well);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("alpha_p", "N_plate", N_plate);
      current_statement__ = 65;
      stan::math::validate_non_negative_index("delta_t", "N_group", N_group);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 0U;
  }
  inline std::string model_name() const final {
    return "model_gen_F";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_gen_F_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_gen_F_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      std::vector<double> y =
        std::vector<double>(N_well, std::numeric_limits<double>::quiet_NaN());
      std::vector<Eigen::Matrix<double,-1,1>> delta_tp =
        std::vector<Eigen::Matrix<double,-1,1>>(N_group,
          Eigen::Matrix<double,-1,1>::Constant(N_plate,
            std::numeric_limits<double>::quiet_NaN()));
      Eigen::Matrix<double,-1,1> kappa =
        Eigen::Matrix<double,-1,1>::Constant(N_well,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu =
        Eigen::Matrix<double,-1,1>::Constant(N_well,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu_well =
        Eigen::Matrix<double,-1,1>::Constant(N_well,
          std::numeric_limits<double>::quiet_NaN());
      double sigma_bio = std::numeric_limits<double>::quiet_NaN();
      double sigma_tech = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> alpha_p =
        Eigen::Matrix<double,-1,1>::Constant(N_plate,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> delta_t =
        Eigen::Matrix<double,-1,1>::Constant(N_group,
          std::numeric_limits<double>::quiet_NaN());
      double kappa_mu = std::numeric_limits<double>::quiet_NaN();
      double kappa_sigma = std::numeric_limits<double>::quiet_NaN();
      int well_id = std::numeric_limits<int>::min();
      current_statement__ = 15;
      for (int i = 1; i <= N_plate; ++i) {
        current_statement__ = 13;
        stan::model::assign(alpha_p,
          stan::math::normal_rng(prior_alpha_p_M, prior_alpha_p_SD,
            base_rng__), "assigning variable alpha_p",
          stan::model::index_uni(i));
      }
      current_statement__ = 18;
      for (int i = 1; i <= N_group; ++i) {
        current_statement__ = 16;
        stan::model::assign(delta_t,
          stan::math::normal_rng(prior_delta_t_M, prior_delta_t_SD,
            base_rng__), "assigning variable delta_t",
          stan::model::index_uni(i));
      }
      current_statement__ = 19;
      sigma_bio = stan::math::abs(
                    stan::math::normal_rng(prior_sigma_bio_M,
                      prior_sigma_bio_SD, base_rng__));
      current_statement__ = 20;
      sigma_tech = stan::math::abs(
                     stan::math::normal_rng(prior_sigma_tech_M,
                       prior_sigma_bio_SD, base_rng__));
      current_statement__ = 21;
      kappa_mu = stan::math::normal_rng(prior_kappa_mu_M, prior_kappa_mu_SD,
                   base_rng__);
      current_statement__ = 22;
      kappa_sigma = stan::math::abs(
                      stan::math::normal_rng(prior_kappa_sigma_M,
                        prior_kappa_sigma_SD, base_rng__));
      current_statement__ = 23;
      well_id = 1;
      current_statement__ = 39;
      for (int g = 1; g <= N_group; ++g) {
        current_statement__ = 36;
        for (int p = 1; p <= N_plate; ++p) {
          current_statement__ = 24;
          stan::model::assign(delta_tp,
            stan::math::normal_rng(
              stan::model::rvalue(delta_t, "delta_t",
                stan::model::index_uni(g)), sigma_bio, base_rng__),
            "assigning variable delta_tp", stan::model::index_uni(g),
            stan::model::index_uni(p));
          current_statement__ = 34;
          for (int w = 1; w <= N_well_reps; ++w) {
            current_statement__ = 27;
            if (stan::math::logical_eq(g, offset)) {
              current_statement__ = 25;
              stan::model::assign(mu_well,
                stan::math::normal_rng(
                  stan::model::rvalue(alpha_p, "alpha_p",
                    stan::model::index_uni(p)), sigma_tech, base_rng__),
                "assigning variable mu_well", stan::model::index_uni(well_id));
            }
            current_statement__ = 30;
            if (stan::math::logical_neq(g, offset)) {
              current_statement__ = 28;
              stan::model::assign(mu_well,
                stan::math::normal_rng(
                  (stan::model::rvalue(alpha_p, "alpha_p",
                     stan::model::index_uni(p)) +
                  stan::model::rvalue(
                    stan::model::rvalue(delta_tp, "delta_tp",
                      stan::model::index_uni(g)), "delta_tp[g]",
                    stan::model::index_uni(p))), sigma_tech, base_rng__),
                "assigning variable mu_well", stan::model::index_uni(well_id));
            }
            current_statement__ = 31;
            stan::model::assign(kappa,
              stan::math::exp(
                stan::math::normal_rng(kappa_mu, kappa_sigma, base_rng__)),
              "assigning variable kappa", stan::model::index_uni(well_id));
            current_statement__ = 32;
            well_id = (well_id + 1);
          }
        }
        current_statement__ = 37;
        stan::model::assign(mu, stan::math::exp(mu_well),
          "assigning variable mu");
      }
      current_statement__ = 40;
      stan::model::assign(y,
        stan::math::gamma_rng(kappa, stan::math::elt_divide(kappa, mu),
          base_rng__), "assigning variable y");
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "kappa", kappa, 0);
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "mu", mu, 0);
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "sigma_bio", sigma_bio,
        0);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "sigma_tech",
        sigma_tech, 0);
      out__.write(y);
      for (int sym1__ = 1; sym1__ <= N_plate; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_group; ++sym2__) {
          out__.write(delta_tp[(sym2__ - 1)][(sym1__ - 1)]);
        }
      }
      out__.write(kappa);
      out__.write(mu);
      out__.write(mu_well);
      out__.write(sigma_bio);
      out__.write(sigma_tech);
      out__.write(alpha_p);
      out__.write(delta_t);
      out__.write(kappa_mu);
      out__.write(kappa_sigma);
      out__.write(well_id);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"y", "delta_tp", "kappa", "mu", "mu_well", "sigma_bio",
             "sigma_tech", "alpha_p", "delta_t", "kappa_mu", "kappa_sigma",
             "well_id"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(N_well)},
             std::vector<size_t>{static_cast<size_t>(N_group),
               static_cast<size_t>(N_plate)},
             std::vector<size_t>{static_cast<size_t>(N_well)},
             std::vector<size_t>{static_cast<size_t>(N_well)},
             std::vector<size_t>{static_cast<size_t>(N_well)},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(N_plate)},
             std::vector<size_t>{static_cast<size_t>(N_group)},
             std::vector<size_t>{}, std::vector<size_t>{},
             std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "y" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_plate; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_group; ++sym2__) {
          param_names__.emplace_back(std::string() + "delta_tp" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "kappa" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_well" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "sigma_bio");
      param_names__.emplace_back(std::string() + "sigma_tech");
      for (int sym1__ = 1; sym1__ <= N_plate; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha_p" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_group; ++sym1__) {
        param_names__.emplace_back(std::string() + "delta_t" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "kappa_mu");
      param_names__.emplace_back(std::string() + "kappa_sigma");
      param_names__.emplace_back(std::string() + "well_id");
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "y" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_plate; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N_group; ++sym2__) {
          param_names__.emplace_back(std::string() + "delta_tp" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "kappa" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_well; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_well" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "sigma_bio");
      param_names__.emplace_back(std::string() + "sigma_tech");
      for (int sym1__ = 1; sym1__ <= N_plate; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha_p" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N_group; ++sym1__) {
        param_names__.emplace_back(std::string() + "delta_t" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "kappa_mu");
      param_names__.emplace_back(std::string() + "kappa_sigma");
      param_names__.emplace_back(std::string() + "well_id");
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"y\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_well) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"delta_tp\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_group) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_plate) + "}},\"block\":\"generated_quantities\"},{\"name\":\"kappa\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_well) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_well) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu_well\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_well) + "},\"block\":\"generated_quantities\"},{\"name\":\"sigma_bio\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"sigma_tech\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"alpha_p\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_plate) + "},\"block\":\"generated_quantities\"},{\"name\":\"delta_t\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_group) + "},\"block\":\"generated_quantities\"},{\"name\":\"kappa_mu\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"kappa_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"well_id\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"y\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_well) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"delta_tp\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(N_group) + ",\"element_type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_plate) + "}},\"block\":\"generated_quantities\"},{\"name\":\"kappa\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_well) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_well) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu_well\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_well) + "},\"block\":\"generated_quantities\"},{\"name\":\"sigma_bio\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"sigma_tech\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"alpha_p\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_plate) + "},\"block\":\"generated_quantities\"},{\"name\":\"delta_t\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_group) + "},\"block\":\"generated_quantities\"},{\"name\":\"kappa_mu\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"kappa_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"well_id\",\"type\":{\"name\":\"int\"},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 0;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities *
      ((((((((((((N_well + (N_group * N_plate)) + N_well) + N_well) + N_well)
      + 1) + 1) + N_plate) + N_group) + 1) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = 0;
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities *
      ((((((((((((N_well + (N_group * N_plate)) + N_well) + N_well) + N_well)
      + 1) + 1) + N_plate) + N_group) + 1) + 1) + 1));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_gen_F_namespace::model_gen_F;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_gen_F_namespace::profiles__;
}
#endif
#endif
