\name{get_pairs}
\alias{get_pairs}
\title{Pairwise comparison of treatment effects on cell migration speed}
\usage{
get_pairs(x, groups, exponentiate)
}
\arguments{
\item{x}{An object generated by \code{cellmig}}
\item{groups}{Optional character vector specifying treatment groups to include.
Available groups can be obtained using \code{\link{get_groups}}.}
\item{exponentiate}{Logical. If \code{TRUE}, treatment effects are 
exponentiated, transforming log-scale effects into fold changes.}
}
\value{
A list containing:
\itemize{
  \item \code{comparisons}: A data frame with one row per pairwise comparison,
  containing:
  \describe{
    \item{\code{group_x}}{First treatment group.}
    \item{\code{group_y}}{Second treatment group.}
    \item{\eqn{\rho_M}}{Posterior mean of the difference in treatment effects.}
    \item{\eqn{\rho_{L95}}}{Lower bound of the 95\% credible interval.}
    \item{\eqn{\rho_{H95}}}{Upper bound of the 95\% credible interval.}
    \item{\eqn{\pi}}{Posterior probability of differential effects.}
  }
  \item \code{plot_rho}: A heatmap (ggplot2 object) of \eqn{\rho} values for all
  treatment group pairs.
  \item \code{plot_pi}: A heatmap (ggplot2 object) of \eqn{\pi} values for all
  treatment group pairs.
}
}
\description{
The function \code{get_pairs} performs pairwise comparisons of overall
treatment effects by computing differences between their posterior
distributions.
}
\details{
The main input, \code{x}, is the output of the \code{cellmig} function.
For each pair of treatment groups, \code{get_pairs} extracts the posterior
distributions of their cell migration speed effects and computes the
difference between them. This difference defines a posterior distribution
denoted by \eqn{\rho}.

The 95\% credible interval of \eqn{\rho} is summarized by its lower
(\eqn{\rho_{L95}}) and upper (\eqn{\rho_{H95}}) bounds.

The posterior probability of differential effects, \eqn{\pi}, is defined as:
\deqn{
\pi = 2 \cdot \max\left(
\int_{-\infty}^{0} \rho,\,
\int_{0}^{+\infty} \rho
\right) - 1
}

If \eqn{\rho} and its 95\% credible interval lie mostly or entirely below zero,
there is strong evidence for a lower cell migration speed effect in treatment
group \eqn{i} compared to \eqn{j}. Conversely, if \eqn{\rho} and its 95\%
credible interval lie mostly or entirely above zero, there is strong evidence
for a higher effect in treatment group \eqn{i} compared to \eqn{j}.

If the 95\% credible interval of \eqn{\rho} overlaps zero substantially, the
data do not provide clear evidence for a difference between treatment groups.
Note that lack of clear evidence does not imply absence of an effect, as wide
credible intervals may still include biologically relevant differences.
}
\examples{
data(d_mini, package = "cellmig")
o <- cellmig(x = d_mini,
             control = list(mcmc_warmup = 200,
                            mcmc_steps = 500,
                            mcmc_chains = 2,
                            mcmc_cores = 2,
                            mcmc_algorithm = "NUTS",
                            adapt_delta = 0.8,
                            max_treedepth = 10))
u <- get_pairs(x = o, exponentiate = FALSE)
head(u)
}
