\name{get_dose_response_profile}
\alias{get_dose_response_profile}
\title{Visualization of dose--response profiles}
\usage{
get_dose_response_profile(x,
                          hc_link = "average",
                          hc_dist = "euclidean",
                          groups,
                          B = 1000,
                          exponentiate)
}
\arguments{
  \item{x}{An object generated by \code{cellmig}}
  \item{hc_link}{Character. Linkage method used for hierarchical clustering 
  (e.g., \code{"average"}, \code{"complete"}, \code{"single"}).}
  \item{hc_dist}{Character. Distance metric used for hierarchical clustering 
  (e.g., \code{"euclidean"}, \code{"manhattan"}).}
  \item{groups}{Optional character vector specifying a subset of treatment 
  groups (compound--dose combinations) to include in the analysis.}
  \item{B}{Integer. Number of posterior samples drawn for visualization.}
  \item{exponentiate}{Logical. If \code{TRUE}, treatment effects are 
  exponentiated, transforming log-scale effects into fold changes.}
}
\value{A patchwork plot containing: 
\itemize{ 
  \item \strong{A}: Hierarchical dendrogram comparing compound 
  effect curves. 
  \item \strong{B}: Mean effects of compounds and doses on cell 
  migration speed with 95\% credible intervals. 
  \item \strong{C}: Mean effects of compounds and doses on cell 
  migration speed in each replicate with 95\% credible intervals.
  }
}
\description{
The function takes as its main input (\code{x}) the output of the 
\code{cellmig} function. Users can select a subset of treatment 
groups (compounds + dose combinations) using \code{groups}. To 
construct the hierarchical dendrogram, one has to select a distance 
metric, \code{hc_dist}, (e.g. \code{hc_dist} = "euclidean"); and a 
linkage function, \code{hc_link}, (e.g. \code{hc_link} = "average").
}
\details{
The function \code{get_dose_response_profile} visualizes compound 
effect profiles, identifying compounds with similar effects on cell 
migration speed across different doses. These compounds are clustered 
together in the hierarchical dendrogram.
}
\examples{
data(d, package = "cellmig")
o <- cellmig(x = d,
            control = list(mcmc_warmup = 200,
                           mcmc_steps = 500,
                           mcmc_chains = 2,
                           mcmc_cores = 2,
                           mcmc_algorithm = "NUTS",
                           adapt_delta = 0.8,
                           max_treedepth = 10))

p <- get_dose_response_profile(x = o,
                               hc_link = "average",
                               hc_dist = "euclidean",
                               B = 100,
                               exponentiate = TRUE)
p
}
