% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{setCellsMeta}
\alias{setCellsMeta}
\title{Set MetaData}
\usage{
setCellsMeta(tc_obj, experiment = NULL, condition = NULL, replicate = NULL)
}
\arguments{
\item{tc_obj}{a \code{trackedCells} object}

\item{experiment}{string, a label to describe the experiment
(optional). Can be NULL}

\item{condition}{string, a label to describe the experimental
condition (optional). Can be NULL}

\item{replicate}{string, a label to identify the replicate
(optional). Can be NULL}
}
\value{
a list including three items: experiment name, condition label,
and replicate ID.
}
\description{
Write/Replace MetaData of a trackedCells object
}
\examples{
x0 <- get(data(TrackCellsDataset))
x0 <- setCellsMeta(x0, experiment = "my_exp_01", condition = "DMSO")
getCellsMeta(x0)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
