% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{plotAllTracks}
\alias{plotAllTracks}
\title{A 2D rose-plot}
\usage{
plotAllTracks(
  object,
  Type = "l",
  FixedField = TRUE,
  export = FALSE,
  ExpName = NULL
)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list
of data frames resulted from the PreProcessing.}

\item{Type}{has to be one of the following: c("p", "l", "b", "o")
"p": Points;
"l": Lines;
"b": Both;
"o": Both "overplotted".}

\item{FixedField}{logical(1) Allows generating a plot with
fixed field 800um x 800um. Default is TRUE.}

\item{export}{if `TRUE` (default), exports plot to JPG file}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
A 2D rose-plot showing the tracks of all cells.
}
\description{
Plotting the trajectory data of all cells.
}
\details{
The visualization shows centered trajectories where
the starting point of each track is located at the origin
of the coordinate system (X=0,Y=0).
}
\examples{
rmTD <- get(data(preProcCellMig))
plotAllTracks(object=rmTD, Type="l", FixedField=TRUE,export=FALSE)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
