% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{plot3DTracks}
\alias{plot3DTracks}
\title{A 3D rose-plot}
\usage{
plot3DTracks(object, VS = 3, size = 2, cells, interactive = TRUE)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of
data frames resulted from the PreProcessing.}

\item{VS}{A numeric value of the vertical separator between cells.}

\item{size}{A numeric value of the point's size.}

\item{cells}{A numeric vector containing the cell's numbers to be
plotted.}

\item{interactive}{logical, shall a 3D plot built in an interactive way.}
}
\value{
A 3D rose-plot showing the tracks of particular cells.
}
\description{
Plotting the trajectory data of particular cells in
3D.
}
\details{
The 3D visualization shows centered trajectories
where the starting point of each track is located at the origin
of the coordinate system (X=0,Y=0).
}
\note{
This function requires the \code{rgl} package to be installed on your
system.
}
\examples{
if (Sys.info()[["sysname"]] != "Darwin") {
  # interactive shall be set to TRUE (default)
  rmTD <- get(data(preProcCellMig))
  plot3DTracks(rmTD, VS=3, size=2, cells=seq(1,5,by=1), interactive = FALSE)
}

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
