% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{pkfnd}
\alias{pkfnd}
\title{Find Signal Peaks}
\usage{
pkfnd(im, th, sz = NULL)
}
\arguments{
\item{im}{image to process, particle should be bright spots on
dark background
with little noise ofen an bandpass filtered brightfield image}

\item{th}{the minimum brightness of a pixel that might be local
maxima.
NOTE: Make it big and the code runs faster but you might miss some
particles.
Make it small and you'll get everything and it'll be slow.}

\item{sz}{if your data is noisy, (e.g. a single particle has
multiple
local maxima),
then set this optional keyword to a value slightly larger than
the diameter of your blob.
If multiple peaks are found withing a radius of sz/2 then the code
will keep only the brightest.
Also gets rid of all peaks within sz of boundary}
}
\value{
a numeric data.frame with two columns,
with the coordinates of local maxima
}
\description{
Finds local maxima in an image to pixel level accuracy.
This provides a rough guess
of particle centers to be used by cntrd(). Inspired by
the lmx subroutine of
Grier and Crocker's.
CREATED: Eric R. Dufresne, Yale University, Feb 4 2005.
}
\examples{
x0 <- getCellImages(get(data(TrackCellsDataset)))
x0 <- x0$images[[1]][seq(80,150,by=1), seq(80,150,by=1)]
b <- cellmigRation:::bpass(image_array = x0, lnoise = 2,
                           lobject = 15, threshold = 1)
pk <- cellmigRation:::pkfnd(b, th = 2, sz = 5)
pk

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
