% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{getDACtable}
\alias{getDACtable}
\title{Getting the Direction AutoCorrelation}
\usage{
getDACtable(object)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of
data frames resulted from the PreProcessing.}
}
\value{
A data frame which contains six rows: "Cell Number",
"Angular Persistence", "Intercept of DA quadratic model",
"Mean Direction AutoCorrelation (all lags)",
"Stable Direction AutoCorrelation through the track"
and "Difference between Mean DA and Intercept DA".
}
\description{
The DiAutoCor function automatically compute the
angular persistence across several sequantial time intervals.
}
\examples{

data(TrajectoryDataset)
rmDF=TrajectoryDataset[seq(1,300,by=1),]
rmTD <- CellMig(rmDF)
rmTD <- rmPreProcessing(rmTD,FrameN=55)
rmTD <- DiAutoCor(rmTD, TimeInterval=10, sLAG=0.25, sPLOT=FALSE,
                  aPLOT=FALSE, export=FALSE)
head(getDACtable(rmTD))

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
