% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_extra.R
\docType{data}
\name{WSADataset}
\alias{WSADataset}
\title{Trajectories of 147 cells}
\format{
A data frame with 11970 rows and 4 columns
}
\usage{
data(WSADataset)
}
\description{
A dataset containing the coordinates and the ID of 147 cells from
wound scratch migration experiment
}
\details{
BT549 cell trajectories were computed using cellmigRation.  
Imaging experiments were performed as described by Ghannoum S 
et al (paper in preparation). Briefly, triple negative breast 
cancer BT549 cells were cultured in RPMI supplemented with 10% FCS 
and 1% penicillin/streptomycin. Cells were transduced with 
NucLight green lentivirus (Essen BioScience), and then sorted by  
fluorescence-activated cell sorting (FACS). GFP-positive cells 
were seeded at a 1:3 ratio with untransduced BT549 cells in 
96-well image-lock plates (EssenBio) at a density of 1000 
total cells per well. Once cells reached the desired density,
a thin wound was introduced by scratching the cell monolayer. 
Next, cells were scanned at ten-minute 
intervals over 24h using an 
Incucyte S3 Live-Cell microscope (EssenBio) at 10x magnification 
and a Basler Ace 1920-155um camera with CMOS sensor. TIFF images 
were imported and processed using the cellmigRation library.
}
\examples{
data(WSADataset)

}
\keyword{internal}
