% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{VeAutoCor}
\alias{VeAutoCor}
\title{Velocity AutoCorrelation}
\usage{
VeAutoCor(
  object,
  TimeInterval = 10,
  sLAG = 0.25,
  sPLOT = TRUE,
  aPLOT = TRUE,
  export = FALSE,
  ExpName = NULL
)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}

\item{TimeInterval}{A numeric value of the time elapsed between
successive frames in the time-lapse stack.}

\item{sLAG}{A numeric value to be used to get the number of lags
for the slope fitting. Default is 0.25, which represents 25
percent of the steps.}

\item{sPLOT}{A logical vector that allows generating individual
plots showing the velocity across several sequantial time
intervals. Default is TRUE.}

\item{aPLOT}{A logical vector that allows generating a plot
showing the velocity across several sequantial time intervals
of all cells. Default is TRUE.}

\item{export}{if `TRUE` (default), exports function output to
CSV file}

\item{ExpName}{string, name of the experiment. Can be NULL}
}
\value{
Plots and a data frame, which contains six rows:
"Cell Number", "Velocity AutoCorrelation (lag=1)",
"2nd normalized Velocity AutoCorrelation",
"Intercept of VA quadratic model",
"Mean Velocity AutoCorrelation (all lags)", "Mean |Acceleration|"
and "Average Speed".
}
\description{
The VeAutoCor function automatically compute the
changes in both speed and direction across several sequantial time
intervals.
}
\examples{
data(TrajectoryDataset)
rmDF=TrajectoryDataset[1:300,]
rmTD <- CellMig(rmDF)
rmTD <- rmPreProcessing(rmTD,FrameN=55)
rmTD <- VeAutoCor(rmTD, TimeInterval=10, sLAG=0.25, sPLOT=FALSE,
                  aPLOT=FALSE, export=FALSE)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
