% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{MakeHypercube}
\alias{MakeHypercube}
\title{Make Hypercube}
\usage{
MakeHypercube(vals, dims)
}
\arguments{
\item{vals}{vector of values used to fill the hyper cube}

\item{dims}{integer indicating the number of dimensions.
The resulting molden data frame will have a number of columns
equal to dims}
}
\value{
Matrix corresponding to a molten hyper cube.
The number of columns is equal to dims;
the number of rows is equal to length(vals) ^ dims
}
\description{
Creates a Molten Hypercube with a user-defined number of
dimensions.
The values supplied by the user are used to fill each dimension.
All possible combination of values are included in
the resulting hyper cube.
}
\examples{
cellmigRation:::MakeHypercube(seq(1,3,by=1), 3)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
