% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{CentroidValidation}
\alias{CentroidValidation}
\title{Validate Centroids}
\usage{
CentroidValidation(
  stack,
  slice,
  lobject,
  threshold,
  pnt.cex = 1.2,
  txt.cex = 0.85,
  offset = 0.18
)
}
\arguments{
\item{stack}{stack of images to be evaluated}

\item{slice}{index of the frame within the stack to be evaluated}

\item{lobject}{integer, length in pixels somewhat larger than
a typical object (cell)}

\item{threshold}{the minimum brightness of a pixel that might
be local maxima. NOTE:
Make it big and the code runs faster but you might miss some
particles.
Make it small and you'll get everything and it'll be slow.}

\item{pnt.cex}{cex of the circle drawn around each cell}

\item{txt.cex}{cex of the text used for annotating cells}

\item{offset}{offset used for annotating cells}
}
\value{
data.frame of centroid positions
}
\description{
Validate parameters used to identify cells in a image stack.
A figure containing current image frame with identified particles
labeled with circles and numerical tags is generated. This function
is included for consistency and compatibility reasons
with the original fastTracks software (Matlab). Also, consider
using
VisualizeStackCentroids() or visualizeCellTracks() instead.
}
\examples{
x <- get(data(TrackCellsDataset))
x <- getCellImages(x)
x$images[[1]] <- x$images[[1]][seq(110,160,by=1), seq(100,160,by=1)]
cellmigRation:::CentroidValidation(x, slice = 1, lobject =10, threshold = 5)

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
