% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{CellMigPCA}
\alias{CellMigPCA}
\title{PCA}
\usage{
CellMigPCA(object, parameters = c(1, 2, 3))
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of
data frames resulted from the PreProcessing.}

\item{parameters}{A numeric vector contains the parameters to
be included in the Principal Component Analysis. These numbers
can be obtained from the outcome of the FinRes() function.}
}
\value{
PCA Graph of cells and PCA Graph of variables.
}
\description{
The CellMigPCA function automatically generates
Principal Component Analysis.
}
\examples{
data(WSADataset)
wasDF=WSADataset[seq(1,300,by=1),]
wsaTD <- CellMig(wasDF)
wsaTD <- wsaPreProcessing(wsaTD,FrameN=55)
wsaTD <-FMI(wsaTD,TimeInterval=10)
wsaTD <-ForwardMigration(wsaTD,TimeInterval=10)
wsaTD <-FinRes(wsaTD,ParCor=FALSE)
PCAplot<-CellMigPCA(wsaTD,parameters=c(1,4))

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
