% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClinical-methods.R
\name{getClinical,CellBaseR-method}
\alias{getClinical,CellBaseR-method}
\alias{getClinical}
\title{getClinical}
\usage{
\S4method{getClinical}{CellBaseR}(object, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{param}{a object of class CellBaseParam specifying the parameters
limiting the CellBaseR}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query Clinical data from Cellbase web services.
}
\details{
This method retrieves clinicaly relevant variants annotations from
multiple resources including clinvar, cosmic and gwas catalog. Furthermore,
 the user can filter these data in many ways including trait, features, rs,
 etc,.
}
\examples{
   cb <- CellBaseR()
   cbParam <- CellBaseParam(feature=c("TP73","TET1"), limit=100)
   res <- getClinical(object=cb,param=cbParam)
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
