% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celdaGridSearch.R
\name{subsetCeldaList}
\alias{subsetCeldaList}
\alias{subsetCeldaList,SingleCellExperiment-method}
\alias{subsetCeldaList,celdaList-method}
\title{Subset celda model from SCE object returned from
 \code{celdaGridSearch}}
\usage{
subsetCeldaList(x, params, altExpName = "featureSubset")

\S4method{subsetCeldaList}{SingleCellExperiment}(x, params, altExpName = "featureSubset")

\S4method{subsetCeldaList}{celdaList}(x, params)
}
\arguments{
\item{x}{Can be one of
\itemize{
 \item A \linkS4class{SingleCellExperiment} object returned from
 \code{celdaGridSearch}, \code{recursiveSplitModule},
 or \code{recursiveSplitCell}. Must contain a list named
 \code{"celda_grid_search"} in \code{metadata(x)}.
 \item celdaList object.}}

\item{params}{List. List of parameters used to subset the matching celda
models in list \code{"celda_grid_search"} in \code{metadata(x)}.}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
One of
\itemize{
 \item A new \linkS4class{SingleCellExperiment} object containing
 all models matching the
 provided criteria in \code{params}. If only one celda model result in the
 \code{"celda_grid_search"} slot in \code{metadata(x)} matches
 the given criteria, a new \linkS4class{SingleCellExperiment} object
 with the matching model stored in the
 \link{metadata}
 \code{"celda_parameters"} slot will be returned. Otherwise, a new
 \linkS4class{SingleCellExperiment} object with the subset models stored
 in the \link{metadata}
 \code{"celda_grid_search"} slot will be returned.
 \item A new \code{celdaList} object containing all models matching the
 provided criteria in \code{params}. If only one item in the
 \code{celdaList} matches the given criteria, the matching model will be
 returned directly instead of a \code{celdaList} object.}
}
\description{
Select a subset of models from a
 \linkS4class{SingleCellExperiment} object generated by
 \link{celdaGridSearch} that match the criteria in the argument
 \code{params}.
}
\examples{
data(sceCeldaCGGridSearch)
sceK5L10 <- subsetCeldaList(sceCeldaCGGridSearch,
    params = list(K = 5, L = 10))
data(celdaCGGridSearchRes)
resK5L10 <- subsetCeldaList(celdaCGGridSearchRes,
    params = list(K = 5, L = 10))
}
\seealso{
\link{celdaGridSearch} can run Celda with multiple parameters and
 chains in parallel. \link{selectBestModel} can get the best model for each
 combination of parameters.
}
