% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decon.R
\name{simulateContamination}
\alias{simulateContamination}
\title{Simulate contaminated count matrix}
\usage{
simulateContamination(
  C = 300,
  G = 100,
  K = 3,
  NRange = c(500, 1000),
  beta = 0.1,
  delta = c(1, 10),
  numMarkers = 3,
  seed = 12345
)
}
\arguments{
\item{C}{Integer. Number of cells to be simulated. Default \code{300}.}

\item{G}{Integer. Number of genes to be simulated. Default \code{100}.}

\item{K}{Integer. Number of cell populations to be simulated.
Default \code{3}.}

\item{NRange}{Integer vector. A vector of length 2 that specifies the lower
and upper bounds of the number of counts generated for each cell. Default
\code{c(500, 1000)}.}

\item{beta}{Numeric. Concentration parameter for Phi. Default \code{0.1}.}

\item{delta}{Numeric or Numeric vector. Concentration parameter for Theta.
If input as a single numeric value, symmetric values for beta
distribution are specified; if input as a vector of lenght 2, the two
values will be the shape1 and shape2 paramters of the beta distribution
respectively. Default \code{c(1, 5)}.}

\item{numMarkers}{Integer. Number of markers for each cell population.
Default \code{3}.}

\item{seed}{Integer. Passed to \code{\link[withr]{with_seed}}.
For reproducibility, a default value of 12345 is used. If NULL, no calls to
 \code{\link[withr]{with_seed}} are made.}
}
\value{
A list containing the \code{nativeMatirx} (real expression),
\code{observedMatrix} (real expression + contamination), as well as other
parameters used in the simulation.
}
\description{
This function generates a list containing two count matrices --
 one for real expression, the other one for contamination, as well as other
 parameters used in the simulation which can be useful for running
 decontamination.
}
\examples{
contaminationSim <- simulateContamination(K = 3, delta = c(1, 10))
}
\author{
Shiyi Yang, Yuan Yin, Joshua Campbell
}
