% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateCells.R
\name{simulateCells}
\alias{simulateCells}
\title{Simulate count data from the celda generative models.}
\usage{
simulateCells(
  model = c("celda_CG", "celda_C", "celda_G"),
  S = 5,
  CRange = c(50, 100),
  NRange = c(500, 1000),
  C = 100,
  G = 100,
  K = 5,
  L = 10,
  alpha = 1,
  beta = 1,
  gamma = 5,
  delta = 1,
  seed = 12345
)
}
\arguments{
\item{model}{Character. Options available in \code{celda::availableModels}.
Can be one of \code{"celda_CG"}, \code{"celda_C"}, or \code{"celda_G"}.
Default \code{"celda_CG"}.}

\item{S}{Integer. Number of samples to simulate. Default 5. Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_C"}.}

\item{CRange}{Integer vector. A vector of length 2 that specifies the lower
and upper bounds of the number of cells to be generated in each sample.
Default c(50, 100). Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_C"}.}

\item{NRange}{Integer vector. A vector of length 2 that specifies the lower
and upper bounds of the number of counts generated for each cell. Default
c(500, 1000).}

\item{C}{Integer. Number of cells to simulate. Default 100. Only used if
\code{model} is \code{"celda_G"}.}

\item{G}{Integer. The total number of features to be simulated. Default 100.}

\item{K}{Integer. Number of cell populations. Default 5. Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_C"}.}

\item{L}{Integer. Number of feature modules. Default 10. Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_G"}.}

\item{alpha}{Numeric. Concentration parameter for Theta. Adds a pseudocount
to each cell population in each sample. Default 1. Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_C"}.}

\item{beta}{Numeric. Concentration parameter for Phi. Adds a pseudocount to
each feature module in each cell population. Default 1.}

\item{gamma}{Numeric. Concentration parameter for Eta. Adds a pseudocount to
the number of features in each module. Default 5. Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_G"}.}

\item{delta}{Numeric. Concentration parameter for Psi. Adds a pseudocount to
each feature in each module. Default 1. Only used if
\code{model} is one of \code{"celda_CG"} or \code{"celda_G"}.}

\item{seed}{Integer. Passed to \link[withr]{with_seed}. For reproducibility,
a default value of 12345 is used. If NULL, no calls to
\link[withr]{with_seed} are made.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with
 simulated count matrix stored in the "counts" assay slot. Function
 parameter settings are stored in the \link{metadata} slot. For
 \code{"celda_CG"} and \code{"celda_C"} models,
 columns \code{celda_sample_label} and \code{celda_cell_cluster} in
 \link{colData} contain simulated sample labels and
 cell population clusters. For \code{"celda_CG"} and \code{"celda_G"}
 models, column \code{celda_feature_module} in
 \link{rowData} contains simulated gene modules.
}
\description{
This function generates a \linkS4class{SingleCellExperiment}
 containing a simulated counts matrix in the \code{"counts"} assay slot, as
 well as various parameters used in the simulation which can be
 useful for running celda and are stored in \code{metadata} slot. The user
 must provide the desired model (one of celda_C, celda_G, celda_CG) as well
 as any desired tuning parameters for those model's simulation functions
 as detailed below.
}
\examples{
sce <- simulateCells()
}
