% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_functions.R
\name{recodeClusterY}
\alias{recodeClusterY}
\title{Recode feature module labels}
\usage{
recodeClusterY(sce, from, to, altExpName = "featureSubset")
}
\arguments{
\item{sce}{\linkS4class{SingleCellExperiment} object returned from
\link{celda_G} or \link{celda_CG}. Must contain column
\code{celda_feature_module} in
\code{\link{rowData}(altExp(sce, altExpName))}.}

\item{from}{Numeric vector. Unique values in the range of
\code{seq(celdaModules(sce))} that correspond to the original module labels
in \code{sce}.}

\item{to}{Numeric vector. Unique values in the range of
\code{seq(celdaModules(sce))} that correspond to the new module labels.}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
@return \linkS4class{SingleCellExperiment} object with recoded
 feature module labels.
}
\description{
Recode feature module clusters using a mapping in the
 \code{from} and \code{to} arguments.
}
\examples{
data(sceCeldaCG)
sceReorderedY <- recodeClusterY(sceCeldaCG, c(1, 3), c(3, 1))
}
