% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plots heatmap based on Celda model}
\usage{
plotHeatmap(
  counts,
  z = NULL,
  y = NULL,
  scaleRow = scale,
  trim = c(-2, 2),
  featureIx = NULL,
  cellIx = NULL,
  clusterFeature = TRUE,
  clusterCell = TRUE,
  colorScheme = c("divergent", "sequential"),
  colorSchemeSymmetric = TRUE,
  colorSchemeCenter = 0,
  col = NULL,
  annotationCell = NULL,
  annotationFeature = NULL,
  annotationColor = NULL,
  breaks = NULL,
  legend = TRUE,
  annotationLegend = TRUE,
  annotationNamesFeature = TRUE,
  annotationNamesCell = TRUE,
  showNamesFeature = FALSE,
  showNamesCell = FALSE,
  rowGroupOrder = NULL,
  colGroupOrder = NULL,
  hclustMethod = "ward.D2",
  treeheightFeature = ifelse(clusterFeature, 50, 0),
  treeheightCell = ifelse(clusterCell, 50, 0),
  silent = FALSE,
  ...
)
}
\arguments{
\item{counts}{Numeric or sparse matrix. Normalized counts matrix where rows
represent features and columns represent cells. .}

\item{z}{Numeric vector. Denotes cell population labels.}

\item{y}{Numeric vector. Denotes feature module labels.}

\item{scaleRow}{Function. A function to scale each individual row. Set to
NULL to disable. Occurs after normalization and log transformation. Defualt
is 'scale' and thus will Z-score transform each row.}

\item{trim}{Numeric vector. Vector of length two that specifies the lower
and upper bounds for the data. This threshold is applied after row scaling.
Set to NULL to disable. Default c(-2,2).}

\item{featureIx}{Integer vector. Select features for display in heatmap. If
NULL, no subsetting will be performed. Default NULL.}

\item{cellIx}{Integer vector. Select cells for display in heatmap. If NULL,
no subsetting will be performed. Default NULL.}

\item{clusterFeature}{Logical. Determines whether rows should be clustered.
Default TRUE.}

\item{clusterCell}{Logical. Determines whether columns should be clustered.
Default TRUE.}

\item{colorScheme}{Character. One of "divergent" or "sequential". A
"divergent" scheme is best for highlighting relative data (denoted by
'colorSchemeCenter') such as gene expression data that has been normalized
and centered. A "sequential" scheme is best for highlighting data that
are ordered low to high such as raw counts or probabilities. Default
"divergent".}

\item{colorSchemeSymmetric}{Logical. When the colorScheme is "divergent"
and the data contains both positive and negative numbers, TRUE indicates
that the color scheme should be symmetric from
\code{[-max(abs(data)), max(abs(data))]}. For example, if the data ranges
goes from -1.5 to 2, then setting this to TRUE will force the color scheme
to range from -2 to 2. Default TRUE.}

\item{colorSchemeCenter}{Numeric. Indicates the center of a "divergent"
colorScheme. Default 0.}

\item{col}{Color for the heatmap.}

\item{annotationCell}{Data frame. Additional annotations for each cell will
be shown in the column color bars. The format of the data frame should be
one row for each cell and one column for each annotation. Numeric variables
will be displayed as continuous color bars and factors will be displayed as
discrete color bars. Default NULL.}

\item{annotationFeature}{A data frame for the feature annotations (rows).}

\item{annotationColor}{List. Contains color scheme for all annotations. See
`?pheatmap` for more details.}

\item{breaks}{Numeric vector. A sequence of numbers that covers the range
of values in the normalized `counts`. Values in the normalized `matrix` are
assigned to each bin in `breaks`. Each break is assigned to a unique color
from `col`. If NULL, then breaks are calculated automatically. Default NULL.}

\item{legend}{Logical. Determines whether legend should be drawn. Default
TRUE.}

\item{annotationLegend}{Logical. Whether legend for all annotations should
be drawn. Default TRUE.}

\item{annotationNamesFeature}{Logical. Whether the names for features should
be shown. Default TRUE.}

\item{annotationNamesCell}{Logical. Whether the names for cells should be
shown. Default TRUE.}

\item{showNamesFeature}{Logical. Specifies if feature names should be shown.
Default TRUE.}

\item{showNamesCell}{Logical. Specifies if cell names should be shown.
Default FALSE.}

\item{rowGroupOrder}{Vector. Specifies the order of feature clusters when
semisupervised clustering is performed on the \code{y} labels.}

\item{colGroupOrder}{Vector. Specifies the order of cell clusters when
semisupervised clustering is performed on the \code{z} labels.}

\item{hclustMethod}{Character. Specifies the method to use for the 'hclust'
function. See `?hclust` for possible values. Default "ward.D2".}

\item{treeheightFeature}{Numeric. Width of the feature dendrogram. Set to 0
to disable plotting of this dendrogram. Default: if clusterFeature == TRUE,
then treeheightFeature = 50, else treeheightFeature = 0.}

\item{treeheightCell}{Numeric. Height of the cell dendrogram. Set to 0 to
disable plotting of this dendrogram. Default: if clusterCell == TRUE, then
treeheightCell = 50, else treeheightCell = 0.}

\item{silent}{Logical. Whether to plot the heatmap.}

\item{...}{Other arguments to be passed to underlying pheatmap function.}
}
\value{
list A list containing dendrogram information and the heatmap grob
}
\description{
Renders a heatmap based on a matrix of counts where rows are
 features and columns are cells.
}
\examples{
data(celdaCGSim, celdaCGMod)
plotHeatmap(celdaCGSim$counts,
  z = celdaClusters(celdaCGMod)$z, y = celdaClusters(celdaCGMod)$y
)
}
