% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perplexity.R
\name{perplexity}
\alias{perplexity}
\alias{perplexity,SingleCellExperiment,ANY-method}
\alias{perplexity,ANY,celda_CG-method}
\alias{perplexity,ANY,celda_C-method}
\alias{perplexity,ANY,celda_G-method}
\title{Calculate the perplexity of a celda model}
\usage{
perplexity(
  x,
  celdaMod,
  useAssay = "counts",
  altExpName = "featureSubset",
  newCounts = NULL
)

\S4method{perplexity}{SingleCellExperiment,ANY}(
  x,
  useAssay = "counts",
  altExpName = "featureSubset",
  newCounts = NULL
)

\S4method{perplexity}{ANY,celda_CG}(x, celdaMod, newCounts = NULL)

\S4method{perplexity}{ANY,celda_C}(x, celdaMod, newCounts = NULL)

\S4method{perplexity}{ANY,celda_G}(x, celdaMod, newCounts = NULL)
}
\arguments{
\item{x}{Can be one of
\itemize{
\item A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, \link{celda_G} or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot.
Rows represent features and columns represent cells.
\item Integer counts matrix. Rows represent features and columns represent
cells. This matrix should be the same as the one used to generate
\code{celdaMod}.}}

\item{celdaMod}{Celda model object. Only works if \code{x} is an integer
counts matrix.}

\item{useAssay}{A string specifying which \link{assay}
slot to use if \code{x} is a \linkS4class{SingleCellExperiment} object.
Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{newCounts}{A new counts matrix used to calculate perplexity. If NULL,
perplexity will be calculated for the matrix in \code{useAssay} slot in
\code{x}. Default NULL.}
}
\value{
Numeric. The perplexity for the provided \code{x} (and
 \code{celdaModel}).
}
\description{
Perplexity is a statistical measure of how well a probability
 model can predict new data. Lower perplexity indicates a better model.
}
\examples{
data(sceCeldaCG)
perplexity <- perplexity(sceCeldaCG)
data(celdaCGSim, celdaCGMod)
perplexity <- perplexity(celdaCGSim$counts, celdaCGMod)
data(celdaCSim, celdaCMod)
perplexity <- perplexity(celdaCSim$counts, celdaCMod)
data(celdaGSim, celdaGMod)
perplexity <- perplexity(celdaGSim$counts, celdaGMod)
}
