% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{logLikelihoodHistory}
\alias{logLikelihoodHistory}
\alias{logLikelihoodHistory,SingleCellExperiment-method}
\alias{logLikelihoodHistory,celdaModel-method}
\title{Get log-likelihood history}
\usage{
logLikelihoodHistory(x, altExpName = "featureSubset")

\S4method{logLikelihoodHistory}{SingleCellExperiment}(x, altExpName = "featureSubset")

\S4method{logLikelihoodHistory}{celdaModel}(x)
}
\arguments{
\item{x}{A \linkS4class{SingleCellExperiment} object
returned by \link{celda_C}, \link{celda_G}, or \link{celda_CG}, or a celda
model object.}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}
}
\value{
Numeric. The log-likelihood at each step of Gibbs sampling used to
 generate the model.
}
\description{
Retrieves the complete log-likelihood from all iterations of
 Gibbs sampling used to generate a celda model.
}
\examples{
data(sceCeldaCG)
logLikelihoodHistory(sceCeldaCG)
data(celdaCGMod)
logLikelihoodHistory(celdaCGMod)
}
