% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celda_functions.R
\name{distinctColors}
\alias{distinctColors}
\title{Create a color palette}
\usage{
distinctColors(
  n,
  hues = c("red", "cyan", "orange", "blue", "yellow", "purple", "green", "magenta"),
  saturationRange = c(0.7, 1),
  valueRange = c(0.7, 1)
)
}
\arguments{
\item{n}{Integer. Number of colors to generate.}

\item{hues}{Character vector. Colors available from `colors()`. These will
be used as the base colors for the clustering scheme in HSV. Different
saturations and values will be generated for each hue. Default c("red",
"cyan", "orange", "blue", "yellow", "purple", "green", "magenta").}

\item{saturationRange}{Numeric vector. A vector of length 2 denoting the
saturation for HSV. Values must be in [0,1]. Default: c(0.25, 1).}

\item{valueRange}{Numeric vector. A vector of length 2 denoting the range
of values for HSV. Values must be in [0,1]. Default: `c(0.5, 1)`.}
}
\value{
A vector of distinct colors that have been converted to HEX from HSV.
}
\description{
Generate a palette of `n` distinct colors.
}
\examples{
colorPal <- distinctColors(6) # can be used in plotting functions
}
