% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_graph.R
\name{vis_graph}
\alias{vis_graph}
\title{Provides visualisation of the graph.}
\usage{
vis_graph(
  input_graph,
  Competing_color = "green",
  mirna_color = "orange",
  Upregulation = "red",
  Downregulation = "blue",
  title = "GRAPH",
  layout = "kk"
)
}
\arguments{
\item{input_graph}{The graph object.}

\item{Competing_color}{The color of competing elements
on the graph with 'green' default.}

\item{mirna_color}{The color of miRNAs on the graph with
'orange' default.}

\item{Upregulation}{The color of Upregulated elements on
the graph with 'red' default.}

\item{Downregulation}{The color of Downregulated elements
on the graph with 'blue' default.}

\item{title}{Title of the given graph.}

\item{layout}{The layout that will be used for
visualisation of the graph.}
}
\value{
The graph object.
}
\description{
`vis_graph` Provides visualisation of the graph.
}
\details{
vis_graph ensures the process to be followed.
}
\examples{

data('minsamp')
data('new_counts')

# Visualisation of graph in steady-state.

 priming_graph(minsamp, Competing_expression, miRNA_expression,
    aff_factor = c(seed_type,energy), deg_factor = region)\%>\%
   vis_graph()

# Visualisation of graph after the change.

 priming_graph(minsamp, Competing_expression, miRNA_expression,
    aff_factor = c(seed_type,energy), deg_factor = region)\%>\%
   update_variables(new_counts)\%>\%
   vis_graph()

}
