% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_vis.R
\name{simulate_vis}
\alias{simulate_vis}
\title{Provides visualisation of the graph in addition to simulate function.}
\usage{
simulate_vis(
  input_graph,
  cycle = 1,
  threshold = 0,
  save = FALSE,
  Competing_color = "green",
  mirna_color = "orange",
  Upregulation = "red",
  Downregulation = "blue",
  title = "GRAPH",
  layout = "kk"
)
}
\arguments{
\item{input_graph}{The graph object that processed in previous steps.}

\item{cycle}{Optimal iteration number for gaining steady-state.}

\item{threshold}{absolute minimum amount of change required to be considered as up/down regulated element}

\item{save}{provides to save graph output}

\item{Competing_color}{The color of competing elements on the graph with "green" default.}

\item{mirna_color}{The color of miRNAs on the graph with "orange" default.}

\item{Upregulation}{The color of Upregulated elements on the graph with "red" default.}

\item{Downregulation}{The color of Downregulated elements on the graph with "blue" default.}

\item{title}{Title of the given graph.}

\item{layout}{The layout that will be used for visualisation of the graph.}
}
\value{
It gives a graph and the images of states in each iteration until the end of the simulation.
}
\description{
simulate_vis provides visualisation of the graph in addition to simulate function.
}
\details{
simulate_vis gives the last graph object and each iterations' image.
}
\examples{

# When does the system gain steady-state conditions again?

## new_counts, the dataset that includes the current counts of nodes.

data("minsamp")
data("new_counts")

priming_graph(minsamp, Competing_expression, miRNA_expression)\%>\%
  update_variables(new_counts)\%>\%
  simulate_vis()

priming_graph(minsamp, Competing_expression, miRNA_expression, 
    aff_factor = c(seed_type,energy), deg_factor = c(region))\%>\%
  update_variables(new_counts)\%>\%
  simulate_vis(cycle = 12)

}
