% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priming_graph.R
\name{priming_graph}
\alias{priming_graph}
\title{Converts the given dataframe using first variable as
competing and the second as miRNA.
The function converts the given dataframe using first
variable as competing and the second as miRNA. If user
defines interaction factors as affinity or degradation,
the factors are taken into account.}
\usage{
priming_graph(
  df,
  competing_count,
  miRNA_count,
  aff_factor = dummy,
  deg_factor = dummy
)
}
\arguments{
\item{df}{A data frame that includes the miRNA and competing targets.}

\item{competing_count}{The counts (or expression) of competing elements of the dataset.}

\item{miRNA_count}{The counts (or expression) of repressive element (miRNA) of the dataset.}

\item{aff_factor}{The parameter/s of binding between miRNA and targets.}

\item{deg_factor}{The parameter/s for degradation of bound miRNA:target complex.}
}
\value{
the graph object.
}
\description{
Converts the given dataframe using first variable as
competing and the second as miRNA.
The function converts the given dataframe using first
variable as competing and the second as miRNA. If user
defines interaction factors as affinity or degradation,
the factors are taken into account.
}
\details{
priming_graph provides grouping of competing targets
and evaluation of targets within the groups taking into account
miRNA:target, target:total target, interaction and degradation
parameters. The target groups are determined according to miRNAs.
If the factors that are important in target interactions are
specified as arguments, the factors also are evaluated separately
within each group. priming_graph also calculates the miRNA efficiency
in steady-state conditions. It is assumed that quantity of competing
targets and miRNAs are shown in the steady-state system after the
miRNAs exhibit repressive efficiency. Note that the data must not
include missing values such as NA or '-'.
}
\examples{

data('minsamp')

priming_graph(minsamp, Competing_expression, miRNA_expression)

priming_graph(minsamp, Competing_expression, miRNA_expression,
    aff_factor = c(seed_type,energy), deg_factor = region)


}
