% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_affected_nodes.R
\name{find_affected_nodes}
\alias{find_affected_nodes}
\title{Finds top affected nodes for perturbation 
from a particular node}
\usage{
find_affected_nodes(
  input_graph,
  node_name,
  how = 1,
  cycle = 1,
  limit = 0,
  top = 5
)
}
\arguments{
\item{input_graph}{The graph object that was processed with priming_graph function.}

\item{node_name}{The node to trigger perturbations.}

\item{how}{The change of count (expression) of the given node in terms of fold change.}

\item{cycle}{The iteration of simulation.}

\item{limit}{The minimum fold change which can be taken into account for
perturbation calculation on all nodes in terms of percentage.}

\item{top}{Determines how many nodes most affected will be listed.}
}
\value{
It gives a tibble form dataset that includes perturbation node, 
affected nodes and changes of them.
}
\description{
Finds top affected nodes for perturbation 
from a particular node
}
\details{
Lists the most affected nodes after perturbation 
initiated from a particular node. In the background, 
it compares the calculated values after
the simulation with their initial values.
}
\examples{

data('midsamp')

midsamp\%>\%
priming_graph(competing_count = Gene_expression, 
              miRNA_count = miRNA_expression)\%>\%
find_affected_nodes(node_name = "Gene1", 
                    how = 2, 
                    cycle = 2, 
                    top = 2)


}
