% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gene_map}
\alias{gene_map}
\title{Plot heatmap of metagene matrix}
\usage{
gene_map(object, rank, markers = NULL, subtract.mean = TRUE,
  log = TRUE, max.per.cluster = 10, Colv = NA, gene.names = NULL,
  main = "Genes", col = NULL, ...)
}
\arguments{
\item{object}{Object of class \code{scNMFSet}.}

\item{rank}{Rank value for which the gene map is to be displayed. 
The object must contain the corresponding slot (one element of 
     \code{basis(object)[[k]]} for which \code{ranks(object)[[k]]==rank}.}

\item{markers}{Vector of gene names containing markers to be included 
in addition to the metagenes. All entries of \code{rowData(object)}
matching them will be added to the metagene list.}

\item{subtract.mean}{Process each rows of basis matrix \code{W} by 
standardization using the mean of elements within the row.}

\item{log}{If \code{TRUE}, \code{subtract.mean} uses geometric mean
and division. Otherwise, use arithmetic mean and subtraction.}

\item{max.per.cluster}{Maximum number of metagenes per cluster.}

\item{Colv}{\code{NA} suppresses reordering and dendrogram of clusters
along the column. See \code{\link[stats]{heatmap}}.}

\item{gene.names}{Names to be used in the plot for genes.}

\item{main}{Title of plot.}

\item{col}{Colors for the cluster panels on the left and top.}

\item{...}{Other arguments to be passed to \code{\link{heatmap}}, 
\code{\link{image}}, and \code{\link{plot}}.}
}
\value{
\code{NULL}
}
\description{
Generate heatmap of metagenes derived from factorization of count data.
}
\details{
Wrapper for \code{\link[stats]{heatmap}} to display metagenes and
associated basis matrix element magnitudes. Factorization results inside
an object specified by its rank value will be retrieved, and metagene
sets identified from clusters.

If \code{object} contains multiple ranks, only the requested 
  rank's basis matrix W will be displayed. The genes displayed in rows
     are selected by "max" scheme
    [Carmona-Saez, BMC Bioinformatics (2006), 
   \url{https://doi.org/10.1186/1471-2105-7-54}]:
     for each cluster (\code{k in 1:ncol}), 
     rows of W are sorted by decreasing order
     of \code{W[,k]}. Marker genes for \code{k} are those among the top
     \code{nmarker} for which \code{W[,k]} is maximum within each row.
}
\examples{
 
set.seed(1)
x <- simulate_data(nfeatures=10,nsamples=c(20,20,60))
rownames(x) <- seq_len(10)
colnames(x) <- seq_len(100)
s <- scNMFSet(count=x,rowData=seq_len(10), colData=seq_len(100))
s <- vb_factorize(s,ranks=seq(2,5))
plot(s)
gene_map(s, rank=3)
}
