% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rowVars_fast}
\alias{rowVars_fast}
\title{Computes Row Variances Efficiently}
\usage{
rowVars_fast(x, n_cores)
}
\arguments{
\item{x}{A numeric dense matrix for which to compute row variances.}

\item{n_cores}{The number of cores to utilize for parallel processing.}
}
\value{
A numeric vector containing the variance for each row of the input
matrix.
}
\description{
Computes Row Variances Efficiently
}
\examples{

library(Matrix)
rand_vals <- sample(0:10,1e4,replace=TRUE, p=c(0.99,rep(0.001,10)))
x <- as.matrix(Matrix(rand_vals,ncol=5))
cores <- 2
vars_vector <- rowVars_fast(x, cores)

}
