% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_models.R
\name{predMixBinom}
\alias{predMixBinom}
\title{Predicted probability from learned binomial mixture model}
\usage{
predMixBinom(k, n, p, psi)
}
\arguments{
\item{k}{A vector of integers. number of success}

\item{n}{A vector of integers. number of trials}

\item{p}{a vector of binomial success probabilities}

\item{psi}{A float between 0 and 1. fraction of each component}
}
\value{
A list with two components: prob, a matrix representing the 
  probability of each of the passed values coming from each component of the
  mixture and logLik, the total log-likelihood of the new samples.
}
\description{
Predicted probability from learned binomial mixture model
}
\examples{
n1 <- array(sample(1:30, 50, replace = TRUE))
n2 <- array(sample(1:30, 200, replace = TRUE))
k1 <- apply(n1, 1, rbinom, n = 1, p = 0.5)
k2 <- apply(n2, 1, rbinom, n = 1, p = 0.01)
RV <- mixBinom(c(k1, k2), c(n1, n2))
RV_pred <- predMixBinom(3, 10, RV$p, RV$psi)
}
