% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_tree}
\alias{plot_tree}
\title{Plot a phylogenetic tree}
\usage{
plot_tree(tree, orient = "h")
}
\arguments{
\item{tree}{A phylgenetic tee object of class "phylo"}

\item{orient}{A string for the orientation of the tree: "v" (vertical) or "h"
(horizontal)}
}
\value{
a ggtree object
}
\description{
Plot a phylogenetic tree
}
\details{
This function plots a phylogenetic tree from an object of class
"phylo", as produced, for example, by the Canopy package.
}
\examples{
data(example_donor)
plot_tree(tree, orient = "v")
}
\references{
This function makes use of the \code{\link{ggtree}} package:

Guangchuang Yu, David Smith, Huachen Zhu, Yi Guan, Tommy Tsan-Yuk Lam.
ggtree: an R package for visualization and annotation of phylogenetic trees
with their covariates and other associated data. Methods in Ecology and
Evolution 2017, 8(1):28-36, doi:10.1111/2041-210X.12628
}
\author{
Davis McCarthy and Yuanhua Huang
}
