% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{rankColumns}
\alias{rankColumns}
\title{Rank columns in a dataset}
\usage{
rankColumns(table, rankingInfo, rankByAscending = TRUE, sort = FALSE)
}
\arguments{
\item{table}{Data table: data; first column must be identifiers}

\item{rankingInfo}{Data table: boolean values of which rows to rank based on
columns (column names to be ranked must exactly match those available in
argument \code{table}); first column must be identifiers}

\item{rankByAscending}{Boolean: rank values based on their ascending
(\code{TRUE}) or descending (\code{FALSE}) order?}

\item{sort}{Boolean: sort data based on rank product's rank (if multiple
methods are available) or by available ranks}
}
\value{
Data table with the contents of \code{table} and extra columns with
  respective rankings
}
\description{
Rank columns in a dataset
}
\details{
The rank product's rank is calculated if more than one method is
  ranked.
}
\note{
The first column of \code{data} and \code{rankingInfo} must contain
  common identifiers.
}
\keyword{internal}
