% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENCODE.R
\name{loadENCODEsamples}
\alias{loadENCODEsamples}
\title{Load ENCODE samples}
\usage{
loadENCODEsamples(metadata, path = ".")
}
\arguments{
\item{metadata}{Character: ENCODE metadata}

\item{path}{Character: path where to download files}
}
\value{
List of loaded ENCODE samples
}
\description{
Samples are automatically downloaded if they are not found in the current
working directory.
}
\examples{
if (interactive()) {
  # Load ENCODE metadata for a specific cell line and gene
  cellLine <- "HepG2"
  gene <- c("EIF4G1", "U2AF2")
  ENCODEmetadata <- downloadENCODEknockdownMetadata(cellLine, gene)

  # Load samples based on filtered ENCODE metadata
  loadENCODEsamples(ENCODEmetadata)
}
}
\seealso{
Other functions related with using ENCODE expression data: 
\code{\link{downloadENCODEknockdownMetadata}()},
\code{\link{performDifferentialExpression}()},
\code{\link{prepareENCODEgeneExpression}()}
}
\concept{functions related with using ENCODE expression data}
