% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{loadCMapZscores}
\alias{loadCMapZscores}
\title{Load matrix of CMap perturbation's differential expression z-scores
(optional)}
\usage{
loadCMapZscores(data, inheritAttrs = FALSE, verbose = TRUE)
}
\arguments{
\item{data}{\code{perturbationChanges} object}

\item{inheritAttrs}{Boolean: convert to \code{perturbationChanges} object and
inherit attributes from \code{data}?}

\item{verbose}{Boolean: print additional details?}
}
\value{
Matrix containing CMap perturbation z-scores (genes as rows,
  perturbations as columns)
}
\description{
Load matrix of CMap perturbation's differential expression z-scores
(optional)
}
\examples{
metadata <- loadCMapData("cmapMetadata.txt", "metadata")
metadata <- filterCMapMetadata(metadata, cellLine="HepG2")
\dontrun{
perts <- prepareCMapPerturbations(metadata, "cmapZscores.gctx",
                                  "cmapGeneInfo.txt")
zscores <- loadCMapZscores(perts[ , 1:10])
}
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{parseCMapID}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{prepareCMapPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
