% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyInterface.R
\name{launchCMapDataLoader}
\alias{launchCMapDataLoader}
\title{Load CMap data via a visual interface}
\usage{
launchCMapDataLoader(
  metadata = "cmapMetadata.txt",
  zscores = "cmapZscores.gctx",
  geneInfo = "cmapGeneInfo.txt",
  compoundInfo = "cmapCompoundInfo.txt",
  cellLine = NULL,
  timepoint = NULL,
  dosage = NULL,
  perturbationType = NULL
)
}
\arguments{
\item{metadata}{Data frame (CMap metadata) or character (respective filepath)}

\item{zscores}{Data frame (GCTX z-scores) or character (respective filepath
to load data from file)}

\item{geneInfo}{Data frame (CMap gene info) or character (respective
filepath to load data from file)}

\item{compoundInfo}{Data frame (CMap compound info) or character (respective
filepath to load data from file)}

\item{cellLine}{Character: cell line (if \code{NULL}, all values are loaded)}

\item{timepoint}{Character: timepoint (if \code{NULL}, all values are loaded)}

\item{dosage}{Character: dosage (if \code{NULL}, all values are loaded)}

\item{perturbationType}{Character: type of perturbation (if \code{NULL}, all
perturbation types are loaded)}
}
\value{
CMap data
}
\description{
Load CMap data via a visual interface
}
\seealso{
Other visual interface functions: 
\code{\link{cTRAP}()},
\code{\link{launchDiffExprLoader}()},
\code{\link{launchDrugSetEnrichmentAnalyser}()},
\code{\link{launchMetadataViewer}()},
\code{\link{launchResultPlotter}()}
}
\concept{visual interface functions}
