% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compareWithAllMethods}
\alias{compareWithAllMethods}
\title{Compare reference using all methods}
\usage{
compareWithAllMethods(
  method,
  input,
  reference,
  geneSize = 150,
  cellLines = NULL,
  cellLineMean = "auto",
  rankPerCellLine = FALSE,
  threads = 1,
  chunkGiB = 1,
  verbose = FALSE
)
}
\arguments{
\item{method}{Character: comparison method (\code{spearman}, \code{pearson}
or \code{gsea}; multiple methods may be selected at once)}

\item{input}{\code{Named numeric vector} of differentially expressed genes
whose names are gene identifiers and respective values are a statistic that
represents significance and magnitude of differentially expressed genes
(e.g. t-statistics); or \code{character} of gene symbols composing a gene
set that is tested for enrichment in reference data (only used if
\code{method} includes \code{gsea})}

\item{reference}{Data matrix or \code{character} object with file path to
CMap perturbations (see \code{\link{prepareCMapPerturbations}()}) or gene
expression and drug sensitivity association (see
\code{\link{loadExpressionDrugSensitivityAssociation}()})}

\item{geneSize}{Numeric: number of top up-/down-regulated genes to use as
gene sets to test for enrichment in reference data; if a 2-length numeric
vector, the first index is the number of top up-regulated genes and the
second index is the number of down-regulated genes used to create gene
sets; only used if \code{method} includes \code{gsea} and if \code{input}
is not a gene set}

\item{cellLines}{Integer: number of unique cell lines}

\item{cellLineMean}{Boolean: add rows with the mean of \code{method} across
cell lines? If \code{cellLineMean = "auto"} (default), rows will be added
when data for more than one cell line is available.}

\item{rankPerCellLine}{Boolean: rank results based on both individual cell
lines and mean scores across cell lines (\code{TRUE}) or based on mean
scores alone (\code{FALSE})? If \code{cellLineMean = FALSE}, individual
cell line conditions are always ranked.}

\item{threads}{Integer: number of parallel threads}

\item{chunkGiB}{Numeric: size (in gibibytes) of chunks to load
\code{reference} file; only if argument \code{reference} is a file path}

\item{verbose}{Boolean: print additional details?}

\item{rankByAscending}{Boolean: rank values based on their ascending
(\code{TRUE}) or descending (\code{FALSE}) order?}
}
\value{
List of data tables with correlation and/or GSEA score results
}
\description{
Compare reference using all methods
}
\section{GSEA score}{

  When \code{method = "gsea"}, weighted connectivity scores (WTCS) are
  calculated (\url{https://clue.io/connectopedia/cmap_algorithms}).
}

\keyword{internal}
