% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTRAP-package.r, R/shinyInterface_session.R
\docType{package}
\name{cTRAP}
\alias{cTRAP-package}
\alias{cTRAP}
\title{cTRAP package}
\usage{
cTRAP(
  ...,
  commonPath = "data",
  expire = 14,
  fileSizeLimitMiB = 50,
  flowerURL = NULL,
  port = getOption("shiny.port"),
  host = getOption("shiny.host", "127.0.0.1")
)
}
\arguments{
\item{...}{Objects}

\item{commonPath}{Character: path where to store data common to all sessions}

\item{expire}{Character: days until a session expires (message purposes only)}

\item{fileSizeLimitMiB}{Numeric: file size limit in MiB}

\item{flowerURL}{Character: Flower REST API's URL (\code{NULL} to avoid using
Celery/Flower backend)}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}
}
\value{
Launches result viewer and plotter (returns \code{NULL})
}
\description{
Compare differential gene expression results with those from big datasets
(e.g. CMap), allowing to infer which types of perturbations may explain the
observed difference in gene expression.

Optimised to run in ShinyProxy with Celery/Flower backend with argument
\code{shinyproxy = TRUE}.
}
\details{
\strong{Input:} To use this package, a named vector of differentially
expressed gene metric is needed, where its values represent the significance
and magnitude of the differentially expressed genes (e.g. t-statistic) and
its names are gene symbols.

\strong{Workflow:} The differentially expressed genes will be compared
against selected perturbation conditions by:
\itemize{
    \item{Spearman or Pearson correlation with z-scores of differentially
    expressed genes after perturbations from CMap. Use function
    \code{\link{rankSimilarPerturbations}} with \code{method = "spearman"} or
    \code{method = "pearson"}}
    \item{Gene set enrichment analysis (GSEA) using the (around) 12 000 genes
    from CMap. Use function \code{\link{rankSimilarPerturbations}} with
    \code{method = gsea}.}
}

Available perturbation conditions for CMap include:
\itemize{
    \item{Cell line(s).}
    \item{Perturbation type (gene knockdown, gene upregulation or drug
    intake).}
    \item{Drug concentration.}
    \item{Time points.}
}

Values for each perturbation type can be listed with
\code{getCMapPerturbationTypes()}

\strong{Output:} The output includes a data frame of ranked perturbations
based on the associated statistical values and respective p-values.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://nuno-agostinho.github.io/cTRAP}
  \item \url{https://github.com/nuno-agostinho/cTRAP}
  \item Report bugs at \url{https://github.com/nuno-agostinho/cTRAP/issues}
}


Other visual interface functions: 
\code{\link{launchCMapDataLoader}()},
\code{\link{launchDiffExprLoader}()},
\code{\link{launchDrugSetEnrichmentAnalyser}()},
\code{\link{launchMetadataViewer}()},
\code{\link{launchResultPlotter}()}
}
\author{
\strong{Maintainer}: Nuno Saraiva-Agostinho \email{nunodanielagostinho@gmail.com}

Authors:
\itemize{
  \item Bernardo P. de Almeida
  \item Nuno L. Barbosa-Morais [lead]
}

}
\concept{visual interface functions}
