% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cBioPortalData.R
\name{cBioPortalData}
\alias{cBioPortalData}
\title{Download data from the cBioPortal API}
\usage{
cBioPortalData(
  api,
  studyId = NA_character_,
  genePanelId = NA_character_,
  genes = NA_character_,
  molecularProfileIds = NULL,
  sampleListId = NULL,
  sampleIds = NULL,
  by = c("entrezGeneId", "hugoGeneSymbol"),
  check_build = TRUE,
  ask = interactive()
)
}
\arguments{
\item{api}{An API object of class \code{cBioPortal} from the \code{cBioPortal} function}

\item{studyId}{\code{character(1)} Indicates the "studyId" as taken from
\code{getStudies}}

\item{genePanelId}{\code{character(1)} Identifies the gene panel, as obtained from
the \code{genePanels} function}

\item{genes}{\code{character()} Either Entrez gene identifiers or Hugo gene
symbols. When included, the 'by' argument indicates the type of identifier
provided and 'genePanelId' is ignored. Preference is given to Entrez IDs
due to faster query responses.}

\item{molecularProfileIds}{\code{character()} A vector of molecular profile IDs}

\item{sampleListId}{\code{character(1)} A sample list identifier as obtained from
\code{sampleLists()}}

\item{sampleIds}{\code{character()} Sample identifiers}

\item{by}{\code{character(1)} Either 'entrezGeneId' or 'hugoGeneSymbol' for row
metadata (default: 'entrezGeneId')}

\item{check_build}{logical(1L) Whether to check the build status of the
\code{studyId} using an internal dataset. This argument should be set to
\code{FALSE} if using alternative \code{hostnames}, e.g.,
'pedcbioportal.kidsfirstdrc.org'}

\item{ask}{\code{logical(1)} Whether to prompt the the user before downloading and
loading study \code{MultiAssayExperiment} that is not currently building based
on previous testing. Set to \code{interactive()} by default. In a
non-interactive session, data download will be attempted; equivalent to
\code{ask = FALSE}. The argument will also be used when a cache directory needs
to be created when using \code{downloadStudy}.}
}
\value{
A
\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}
object
}
\description{
Obtain a \code{MultiAssayExperiment} object for a particular gene panel,
\code{studyId}, \code{molecularProfileIds}, and \code{sampleListIds} combination. Default
\code{molecularProfileIds} and \code{sampleListIds} are set to NULL for including all
data. This option is best for users who wish to obtain a section of the
study data that pertains to a specific molecular profile and gene panel
combination. For users looking to download the entire study data as provided
by the \url{https://www.cbioportal.org/datasets}, refer to \code{cBioDataPack}.
}
\details{
We are able to succesfully represent 98 percent of the study
identifiers as \code{MultiAssayExperiment} objects as obtained via
\code{cBioPortalData} with the \code{IMPACT341} \code{genePanelId} as the example
gene panel. Datasets that currently fail to import
can be seen in the \code{getStudies(..., buildReport = TRUE)} dataset
under the \code{"api_build"} column.
Note that changes to the cBioPortal API may affect this rate at any
time. If you encounter any issues, please open a GitHub issue at the
\url{https://github.com/waldronlab/cBioPortalData/issues/} page with
a fully reproducible example.
}
\examples{

cbio <- cBioPortal()

samps <- samplesInSampleLists(cbio, "acc_tcga_rppa")[[1]]

getGenePanelMolecular(
    cbio, molecularProfileIds = c("acc_tcga_rppa", "acc_tcga_linear_CNA"),
    samps
)

acc_tcga <- cBioPortalData(
    cbio, by = "hugoGeneSymbol",
    studyId = "acc_tcga",
    genePanelId = "AmpliSeq",
    molecularProfileIds =
        c("acc_tcga_rppa", "acc_tcga_linear_CNA", "acc_tcga_mutations")
)

}
\seealso{
\link{cBioDataPack}
}
