% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-helper.R
\name{ParseProteinNum}
\alias{ParseProteinNum}
\title{Parse protein information strings or reference strings.}
\usage{
ParseProteinNum(x, type)
}
\arguments{
\item{x}{A string in the format of "#1#" or "#1,2,3#" or "<1,3>".}

\item{type}{Either "protein" or "reference".}
}
\value{
A string, or a vector of strings of protein numbers.
}
\description{
Given a string like "#1,45,72#", parse into a character vector
of c("1", "45", "72"). Consecutive commas are collapsed into one, and spaces
are treated as commas.
}
\examples{
brendaDb:::ParseProteinNum("#1,2,3#", "protein")
# [1] "1,2,3"
brendaDb:::ParseProteinNum("<123>", "reference")
# [1] "123"

}
\keyword{internal}
