% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{ExtractField}
\alias{ExtractField}
\title{Extract a specific field from a brenda.entries object.}
\usage{
ExtractField(res, field, entries = NULL)
}
\arguments{
\item{res}{A brenda.entries object from \code{\link[=QueryBrenda]{QueryBrenda()}}.}

\item{field}{A string indicating the field to extract. Nested fields should
be separated by \code{$}, e.g. \code{parameters$ph.optimum}.}

\item{entries}{A character vector with values of EC numbers. This should be a
subset of \code{names(res)}.}
}
\value{
A tibble with all columns from the tibble in the given field, and
extra columns containing the EC numbers and organisms.
}
\description{
Retrieve one field from all the brenda.entry objects. A column
of EC numbers will be added to distinguish different enzymes.
}
\examples{
df <- ReadBrenda(system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb"))
res <- QueryBrenda(brenda = df, EC = c("1.1.1.1", "6.3.5.8"),
                   n.core = 2)
ExtractField(res, field = "molecular$stability$general.stability")
ExtractField(res, field = "structure$subunits")
}
